/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.path;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.path.Path;

public class ArrayIndexOfPath
implements Path {
    public final JsonNode subseq;
    private final Path parent;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static ArrayIndexOfPath chainIfNotNull(Path parent, JsonNode subseq) {
        if (parent == null) {
            return null;
        }
        return new ArrayIndexOfPath(parent, subseq);
    }

    public ArrayIndexOfPath(Path parent, JsonNode subseq) {
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
        this.parent = parent;
        if (subseq == null) {
            throw new NullPointerException("subseq must not be null");
        }
        if (!subseq.isArray()) {
            throw new IllegalArgumentException("subseq must be an array ");
        }
        this.subseq = subseq;
    }

    @Override
    public void toJsonNode(ArrayNode out) throws JsonQueryException {
        this.parent.toJsonNode(out);
        out.add(this.subseq);
    }

    @Override
    public void get(JsonNode in, Path ipath, PathOutput output, boolean permissive) throws JsonQueryException {
        this.parent.get(in, ipath, (parent, ppath) -> ArrayIndexOfPath.resolve(parent, ppath, output, this.subseq, permissive), permissive);
    }

    @Override
    public JsonNode mutate(JsonNode in, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        return this.parent.mutate(in, oldval -> {
            throw new JsonQueryException("Cannot update field at array index of array");
        }, makeParent);
    }

    private static ArrayNode indexOfAll(JsonNode seq, JsonNode subseq) {
        JsonNodeComparator comparator = JsonNodeComparator.getInstance();
        ArrayNode out = MAPPER.createArrayNode();
        block0: for (int i = 0; i < seq.size() - subseq.size() + 1; ++i) {
            for (int j = 0; j < subseq.size(); ++j) {
                int r = comparator.compare(seq.get(i + j), subseq.get(j));
                if (r != 0) continue block0;
            }
            out.add((JsonNode)IntNode.valueOf((int)i));
        }
        return out;
    }

    public static void resolve(JsonNode pobj, Path ppath, PathOutput output, JsonNode subseq, boolean permissive) throws JsonQueryException {
        assert (subseq.isArray());
        if (pobj.isArray()) {
            ArrayNode indexList = ArrayIndexOfPath.indexOfAll(pobj, subseq);
            output.emit((JsonNode)indexList, ArrayIndexOfPath.chainIfNotNull(ppath, subseq));
        } else if (!permissive) {
            throw new JsonQueryTypeException("Cannot index %s with array", pobj.getNodeType());
        }
    }
}

