/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.module.loaders;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.module.ModuleLoader;

public class ChainedModuleLoader
implements ModuleLoader {
    private final ModuleLoader[] loaders;

    public ChainedModuleLoader(ModuleLoader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    public Module loadModule(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        for (ModuleLoader loader : this.loaders) {
            Module module = loader.loadModule(caller, path, metadata);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    @Override
    public JsonNode loadData(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        for (ModuleLoader loader : this.loaders) {
            JsonNode data = loader.loadData(caller, path, metadata);
            if (data == null) continue;
            return data;
        }
        return null;
    }
}

