/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;

public class JsonQueryKeyFieldConstruction
implements FieldConstruction {
    private final Expression key;
    private final Expression value;

    public JsonQueryKeyFieldConstruction(Expression key, Expression value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void evaluate(Scope scope, JsonNode in, FieldConstruction.FieldConsumer consumer) throws JsonQueryException {
        this.key.apply(scope, in, k -> {
            if (!k.isTextual()) {
                throw new JsonQueryTypeException("Cannot use %s as object key", k);
            }
            this.value.apply(scope, in, v -> consumer.accept(k.asText(), v));
        });
    }

    public String toString() {
        String result = "(" + this.key.toString() + ")";
        return result + ": " + this.value;
    }
}

