/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.path.Path;

public class FunctionCall
implements Expression {
    private final String name;
    private final List<Expression> args;
    private final Version version;
    private final String moduleName;

    public FunctionCall(String moduleName, String name, List<Expression> args, Version version) {
        this.moduleName = moduleName;
        this.name = name;
        this.args = args;
        this.version = version;
    }

    private Function lookupFunction(Scope scope) throws JsonQueryException {
        if (this.moduleName != null) {
            for (Module module : scope.getImportedModules(this.moduleName)) {
                Function f = module.getFunction(this.name, this.args.size());
                if (f == null) continue;
                return f;
            }
            throw new JsonQueryException(String.format("Function %s::%s/%s does not exist", this.moduleName, this.name, this.args.size()));
        }
        Function f = scope.getFunction(this.name, this.args.size());
        if (f != null) {
            return f;
        }
        for (Module module : scope.getImportedModules(null)) {
            Function g = module.getFunction(this.name, this.args.size());
            if (g == null) continue;
            return g;
        }
        throw new JsonQueryException(String.format("Function %s/%s does not exist", this.name, this.args.size()));
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        Function f = this.lookupFunction(scope);
        f.apply(scope, this.args, in, path, output, this.version);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.moduleName != null) {
            builder.append(this.moduleName);
            builder.append("::");
        }
        builder.append(this.name);
        if (!this.args.isEmpty()) {
            builder.append("(");
            String sep = "";
            for (Expression arg : this.args) {
                builder.append(sep);
                if (arg == null) {
                    builder.append("null");
                } else {
                    builder.append(arg.toString());
                }
                sep = "; ";
            }
            builder.append(")");
        }
        return builder.toString();
    }
}

