/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.path.Path;

public class Conditional
implements Expression {
    private Expression otherwise;
    private List<Pair<Expression, Expression>> switches;

    public Conditional(List<Pair<Expression, Expression>> switches, Expression otherwise) {
        this.switches = switches;
        this.otherwise = otherwise;
    }

    private void pathRecursive(PathOutput output, Scope scope, List<Pair<Expression, Expression>> switches, JsonNode in, Path path) throws JsonQueryException {
        Pair<Expression, Expression> sw = switches.get(0);
        ((Expression)sw._1).apply(scope, in, r -> {
            if (JsonNodeUtils.asBoolean(r)) {
                ((Expression)sw._2).apply(scope, in, path, output, false);
            } else if (switches.size() > 1) {
                this.pathRecursive(output, scope, switches.subList(1, switches.size()), in, path);
            } else {
                this.otherwise.apply(scope, in, path, output, false);
            }
        });
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.pathRecursive(output, scope, this.switches, in, path);
    }

    public String toString() {
        String ifstr = "if";
        StringBuilder builder = new StringBuilder();
        for (Pair<Expression, Expression> sw : this.switches) {
            builder.append(ifstr);
            builder.append(" ");
            builder.append(sw._1 != null ? sw._1 : "null");
            builder.append(" ");
            builder.append("then");
            builder.append(" ");
            builder.append(sw._2 != null ? sw._2 : "null");
            builder.append(" ");
            ifstr = "elif";
        }
        builder.append("else ");
        builder.append(this.otherwise != null ? this.otherwise : "null");
        builder.append(" ");
        builder.append("end");
        return builder.toString();
    }
}

