/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.binaryop;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.internal.tree.binaryop.AlternativeOperatorExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.BooleanAndExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.BooleanOrExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.DivideExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.MinusExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.ModuloExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.MultiplyExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.PlusExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.Assignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexAlternativeAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexDivideAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexMinusAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexModuloAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexMultiplyAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexPlusAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.UpdateAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareLessEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareLessTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareNotEqualTest;

public abstract class BinaryOperatorExpression
implements Expression {
    protected Expression lhs;
    protected Expression rhs;
    private String image;

    public BinaryOperatorExpression(Expression lhs, Expression rhs, String image) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.image = image;
    }

    public String toString() {
        return String.format("(%s %s %s)", this.lhs, this.image, this.rhs);
    }

    public static Expression buildTree(List<Expression> exprs, List<Operator> operators, Version version) {
        if (exprs.size() != operators.size() + 1) {
            throw new IllegalArgumentException();
        }
        Stack<Expression> stackExprs = new Stack<Expression>();
        Stack<Operator> stackOperators = new Stack<Operator>();
        Iterator<Expression> iterExpr = exprs.iterator();
        Iterator<Operator> iterOperator = operators.iterator();
        stackExprs.push(iterExpr.next());
        while (iterExpr.hasNext()) {
            Operator op1 = iterOperator.next();
            while (!stackOperators.isEmpty()) {
                Operator op2 = (Operator)((Object)stackOperators.peek());
                if (op1.precedence <= op2.precedence && (op1.precedence != op2.precedence || op1.associativity != Operator.Associativity.LEFT)) break;
                Operator op = (Operator)((Object)stackOperators.pop());
                Expression rhs = (Expression)stackExprs.pop();
                Expression lhs = (Expression)stackExprs.pop();
                stackExprs.push(op.buildTree(lhs, rhs, version));
            }
            stackOperators.push(op1);
            stackExprs.push(iterExpr.next());
        }
        while (!stackOperators.isEmpty()) {
            Operator op = (Operator)((Object)stackOperators.pop());
            Expression rhs = (Expression)stackExprs.pop();
            Expression lhs = (Expression)stackExprs.pop();
            stackExprs.push(op.buildTree(lhs, rhs, version));
        }
        return (Expression)stackExprs.get(0);
    }

    public static enum Operator {
        ASSIGN("=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new Assignment(lhs, rhs);
            }
        }
        ,
        UDPATE("|=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new UpdateAssignment(lhs, rhs, version);
            }
        }
        ,
        DEFAULT_EQUAL("//=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexAlternativeAssignment(lhs, rhs);
            }
        }
        ,
        PLUS_EQUAL("+=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexPlusAssignment(lhs, rhs);
            }
        }
        ,
        MINUS_EQUAL("-=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexMinusAssignment(lhs, rhs);
            }
        }
        ,
        TIMES_EQUAL("*=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexMultiplyAssignment(lhs, rhs);
            }
        }
        ,
        DIVIDE_EQUAL("/=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexDivideAssignment(lhs, rhs);
            }
        }
        ,
        MODULO_EQUAL("%=", 6, Associativity.RIGHT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ComplexModuloAssignment(lhs, rhs);
            }
        }
        ,
        DEFAULT("//", 5, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new AlternativeOperatorExpression(lhs, rhs);
            }
        }
        ,
        OR("or", 4, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new BooleanOrExpression(lhs, rhs);
            }
        }
        ,
        AND("and", 4, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new BooleanAndExpression(lhs, rhs);
            }
        }
        ,
        LESS_EQUAL("<=", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareLessEqualTest(lhs, rhs);
            }
        }
        ,
        LESS("<", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareLessTest(lhs, rhs);
            }
        }
        ,
        GREATER_EQUAL(">=", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareGreaterEqualTest(lhs, rhs);
            }
        }
        ,
        GREATER(">", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareGreaterTest(lhs, rhs);
            }
        }
        ,
        EQUAL("==", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareEqualTest(lhs, rhs);
            }
        }
        ,
        NOT_EQUAL("!=", 3, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new CompareNotEqualTest(lhs, rhs);
            }
        }
        ,
        PLUS("+", 2, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new PlusExpression(lhs, rhs);
            }
        }
        ,
        MINUS("-", 2, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new MinusExpression(lhs, rhs);
            }
        }
        ,
        MODULO("%", 1, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new ModuloExpression(lhs, rhs);
            }
        }
        ,
        DIVIDE("/", 1, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new DivideExpression(lhs, rhs);
            }
        }
        ,
        TIMES("*", 1, Associativity.LEFT){

            @Override
            protected Expression create(Expression lhs, Expression rhs, Version version) {
                return new MultiplyExpression(lhs, rhs);
            }
        };

        public final String image;
        public final int precedence;
        public final Associativity associativity;
        private static final Map<String, Operator> lookup;

        protected abstract Expression create(Expression var1, Expression var2, Version var3);

        private Operator(String image, int precedence, Associativity associativity) {
            this.image = image;
            this.precedence = precedence;
            this.associativity = associativity;
        }

        public static Operator fromImage(String image) {
            Operator op = lookup.get(image);
            if (op == null) {
                throw new IllegalArgumentException();
            }
            return op;
        }

        public Expression buildTree(Expression lhs, Expression rhs, Version version) {
            try {
                return this.create(lhs, rhs, version);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static {
            lookup = new HashMap<String, Operator>();
            for (Operator op : Operator.values()) {
                lookup.put(op.image, op);
            }
        }

        public static enum Associativity {
            LEFT,
            RIGHT;

        }
    }
}

