/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.BuddyInfo;
import net.thisptr.java.procfs.mbeans.agent.mbeans.DiskStats;
import net.thisptr.java.procfs.mbeans.agent.mbeans.LoadAvg;
import net.thisptr.java.procfs.mbeans.agent.mbeans.MemInfo;
import net.thisptr.java.procfs.mbeans.agent.mbeans.SoftIrqs;
import net.thisptr.java.procfs.mbeans.agent.mbeans.Stat;
import net.thisptr.java.procfs.mbeans.agent.mbeans.Stat_Cpu;
import net.thisptr.java.procfs.mbeans.agent.mbeans.VmStat;
import net.thisptr.java.procfs.mbeans.agent.mbeans.cgroup.Cpu;
import net.thisptr.java.procfs.mbeans.agent.mbeans.cgroup.CpuAcct;
import net.thisptr.java.procfs.mbeans.agent.mbeans.cgroup.Memory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.net.NetStat;
import net.thisptr.java.procfs.mbeans.agent.mbeans.net.Snmp;
import net.thisptr.java.procfs.mbeans.agent.mbeans.net.Snmp6;
import net.thisptr.java.procfs.mbeans.agent.mbeans.net.SockStat;
import net.thisptr.java.procfs.mbeans.agent.mbeans.net.SockStat6;
import net.thisptr.java.procfs.mbeans.agent.mbeans.self.ProcessIo;
import net.thisptr.java.procfs.mbeans.agent.mbeans.self.ProcessStat;
import net.thisptr.java.procfs.mbeans.agent.mbeans.self.ProcessStatm;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.Level;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class AgentMain {
    private static final Logger LOG = LoggerFactory.getLogger(AgentMain.class);

    public static void premain(String args, Instrumentation inst) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new NetStat(), new ObjectName("procfs", "path", "/proc/net/netstat"));
        server.registerMBean(new Snmp(), new ObjectName("procfs", "path", "/proc/net/snmp"));
        server.registerMBean(new Snmp6(), new ObjectName("procfs", "path", "/proc/net/snmp6"));
        server.registerMBean(new SockStat(), new ObjectName("procfs", "path", "/proc/net/sockstat"));
        server.registerMBean(new SockStat6(), new ObjectName("procfs", "path", "/proc/net/sockstat6"));
        server.registerMBean(new MemInfo(), new ObjectName("procfs", "path", "/proc/meminfo"));
        server.registerMBean(new VmStat(), new ObjectName("procfs", "path", "/proc/vmstat"));
        server.registerMBean(new LoadAvg(), new ObjectName("procfs", "path", "/proc/loadavg"));
        server.registerMBean(new Stat(), new ObjectName("procfs", "path", "/proc/stat"));
        server.registerMBean(new ProcessStatm(), new ObjectName("procfs", "path", "/proc/self/statm"));
        server.registerMBean(new ProcessStat(), new ObjectName("procfs", "path", "/proc/self/stat"));
        server.registerMBean(new Cpu(), new ObjectName("procfs", "path", "/sys/fs/cgroup/cpu"));
        server.registerMBean(new CpuAcct(), new ObjectName("procfs", "path", "/sys/fs/cgroup/cpuacct"));
        server.registerMBean(new Memory(), new ObjectName("procfs", "path", "/sys/fs/cgroup/memory"));
        AgentMain.discoverOnce(server);
        AgentMain.discoverPeriodically(server);
        Thread th = new Thread(AgentMain::discoveryLoop);
        th.setDaemon(true);
        th.setName("Procfs Discovery");
        th.start();
        LOG.info("Registered /procs MXBeans.");
    }

    private static void discoverDiskStats(MBeanServer server) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, IOException {
        for (String partitionName : DiskStats.listPartitionNames()) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("path", "/proc/diskstats");
            props.put("name", partitionName);
            ObjectName name = new ObjectName("procfs", props);
            if (server.isRegistered(name)) continue;
            server.registerMBean(new DiskStats(partitionName), name);
        }
    }

    private static void discoverBuddyInfo(MBeanServer server) throws IOException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        for (BuddyInfo.ZoneAndOrder zoneAndOrder : BuddyInfo.listZoneAndOrders()) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("node", String.valueOf(zoneAndOrder.node));
            props.put("zone", zoneAndOrder.zone);
            props.put("order", String.valueOf(zoneAndOrder.order));
            props.put("path", "/proc/buddyinfo");
            ObjectName name = new ObjectName("procfs", props);
            if (server.isRegistered(name)) continue;
            server.registerMBean(new BuddyInfo(zoneAndOrder), name);
        }
    }

    private static void discoverSelfIo(MBeanServer server) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (!new File("/proc/self/io").exists()) {
            return;
        }
        ObjectName name = new ObjectName("procfs", "path", "/proc/self/io");
        if (!server.isRegistered(name)) {
            server.registerMBean(new ProcessIo(), name);
        }
    }

    private static void discoverStat_Cpu(MBeanServer server) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        for (String cpu : Stat_Cpu.listCpus()) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("cpu", cpu);
            props.put("path", "/proc/stat");
            ObjectName name = new ObjectName("procfs", props);
            if (server.isRegistered(name)) continue;
            server.registerMBean(new Stat_Cpu(cpu), name);
        }
    }

    private static void discoverSoftIrqs(MBeanServer server) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        for (String cpu : SoftIrqs.listCpus()) {
            for (String softirq : SoftIrqs.listSoftIrqs()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("cpu", cpu);
                props.put("softirq", softirq);
                props.put("path", "/proc/softirqs");
                ObjectName name = new ObjectName("procfs", props);
                if (server.isRegistered(name)) continue;
                server.registerMBean(new SoftIrqs(softirq, cpu), name);
            }
        }
    }

    private static void discoverOnce(MBeanServer server) {
        try {
            AgentMain.discoverSelfIo(server);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        try {
            AgentMain.discoverBuddyInfo(server);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        try {
            AgentMain.discoverSoftIrqs(server);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static void discoverPeriodically(MBeanServer server) {
        try {
            AgentMain.discoverDiskStats(server);
            AgentMain.discoverStat_Cpu(server);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static void discoveryLoop() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        while (true) {
            try {
                while (true) {
                    AgentMain.discoverPeriodically(server);
                    Thread.sleep(300000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        LoggerFactory.configure(Level.INFO, null);
    }
}

