/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent;

import java.nio.charset.StandardCharsets;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.Level;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.LoggerContext;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.PatternLayout;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.classic.spi.ILoggingEvent;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.core.Appender;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.core.ConsoleAppender;
import net.thisptr.java.procfs.mbeans.agent.shade.ch.qos.logback.core.FileAppender;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class LoggerFactory {
    private static final LoggerContext CONTEXT = new LoggerContext();
    private static final String PATTERN = "%d{yyyy-MM-dd'T'HH:mm:ss.SSSXXX} %level [%thread] %logger{10} [%file:%line] %msg%n";
    private static final String ROOT_LOGGER_NAME = "ROOT";
    private static final String STDOUT = "-";

    public static void configure(Level level, String path) {
        LoggerContext context = CONTEXT;
        context.reset();
        PatternLayout layout = new PatternLayout();
        layout.setContext(context);
        layout.setPattern(PATTERN);
        layout.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(context);
        encoder.setCharset(StandardCharsets.UTF_8);
        encoder.start();
        if (path == null || path.isEmpty() || path.equals(STDOUT)) {
            ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
            appender.setEncoder(encoder);
            appender.setContext(context);
            appender.setLayout(layout);
            appender.setTarget(STDOUT.equals(path) ? "System.out" : "System.err");
            appender.setName("CONSOLE");
            appender.start();
            context.getLogger(ROOT_LOGGER_NAME).addAppender((Appender<ILoggingEvent>)appender);
        } else {
            FileAppender<ILoggingEvent> appender = new FileAppender<ILoggingEvent>();
            appender.setEncoder(encoder);
            appender.setContext(context);
            appender.setLayout(layout);
            appender.setFile(path);
            appender.setName("FILE");
            appender.start();
            context.getLogger(ROOT_LOGGER_NAME).addAppender((Appender<ILoggingEvent>)appender);
        }
        context.getLogger(ROOT_LOGGER_NAME).setLevel(level);
        context.start();
    }

    public static Logger getLogger(Class<?> clazz) {
        return CONTEXT.getLogger(clazz.getName());
    }
}

