/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.BuddyInfoMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class BuddyInfo
implements BuddyInfoMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BuddyInfo.class);
    private static final SingleCache<Map<ZoneAndOrder, Long>> CACHE = new SingleCache<Map>(Duration.ofSeconds(1L), () -> {
        HashMap<ZoneAndOrder, Long> pages = new HashMap<ZoneAndOrder, Long>();
        for (String rawLine : MoreFiles.readLines("/proc/buddyinfo")) {
            String[] nodeAndRest = rawLine.split(",", 2);
            String[] nodeName = nodeAndRest[0].split(" ", 2);
            if (nodeName.length != 2) {
                LOG.warn("/proc/buddyinfo: failed to parse node name");
                continue;
            }
            int node = Integer.parseInt(nodeName[1]);
            String[] zoneAndFreePages = nodeAndRest[1].trim().split(" +");
            if (!zoneAndFreePages[0].equals("zone")) {
                LOG.warn("/proc/buddyinfo: failed to parse zone name");
                continue;
            }
            String zone = zoneAndFreePages[1];
            for (int i = 2; i < zoneAndFreePages.length; ++i) {
                int order = i - 2;
                pages.put(new ZoneAndOrder(node, zone, order), Long.valueOf(zoneAndFreePages[i]));
            }
        }
        return pages;
    });
    private final ZoneAndOrder zoneAndOrder;

    public BuddyInfo(ZoneAndOrder zoneAndOrder) {
        this.zoneAndOrder = zoneAndOrder;
    }

    @Override
    public long getnr_free() throws IOException {
        Long pages = CACHE.get().get(this.zoneAndOrder);
        if (pages == null) {
            return -1L;
        }
        return pages;
    }

    public static Collection<ZoneAndOrder> listZoneAndOrders() throws IOException {
        return CACHE.get().keySet();
    }

    public static class ZoneAndOrder {
        public final int node;
        public final String zone;
        public final int order;

        public ZoneAndOrder(int node, String zone, int order) {
            this.node = node;
            this.zone = zone;
            this.order = order;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.node;
            result = 31 * result + this.order;
            result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ZoneAndOrder other = (ZoneAndOrder)obj;
            if (this.node != other.node) {
                return false;
            }
            if (this.order != other.order) {
                return false;
            }
            return !(this.zone == null ? other.zone != null : !this.zone.equals(other.zone));
        }
    }
}

