/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.thisptr.java.procfs.mbeans.agent.mbeans.DiskStatsMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;

public class DiskStats
implements DiskStatsMXBean {
    private static int NAME_COLUMN_INDEX = 2;
    private static SingleCache<Map<String, Data>> CACHE = new SingleCache<Map>(Duration.ofSeconds(1L), () -> {
        HashMap<String, Data> disks = new HashMap<String, Data>();
        for (String line : MoreFiles.readLines("/proc/diskstats")) {
            String[] tokens = line.trim().split(" +");
            String diskName = tokens[NAME_COLUMN_INDEX];
            long[] values = new long[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                if (i == NAME_COLUMN_INDEX) continue;
                values[i] = Long.parseLong(tokens[i]);
            }
            disks.put(diskName, new Data(values));
        }
        return disks;
    });
    private String diskName;

    public DiskStats(String name) {
        this.diskName = name;
    }

    public static Collection<String> listPartitionNames() {
        return CACHE.get().keySet();
    }

    @Override
    public DiskStatsMXBean.ReadWrite getios() {
        return CACHE.get().get(this.diskName).getios();
    }

    @Override
    public DiskStatsMXBean.ReadWrite getmerges() {
        return CACHE.get().get(this.diskName).getmerges();
    }

    @Override
    public DiskStatsMXBean.ReadWrite getsectors() {
        return CACHE.get().get(this.diskName).getsectors();
    }

    @Override
    public DiskStatsMXBean.ReadWrite getticks() {
        return CACHE.get().get(this.diskName).getticks();
    }

    @Override
    public long getinflight() {
        return CACHE.get().get(this.diskName).getinflight();
    }

    @Override
    public long getio_ticks() {
        return CACHE.get().get(this.diskName).getio_ticks();
    }

    @Override
    public long gettime_in_queue() {
        return CACHE.get().get(this.diskName).gettime_in_queue();
    }

    @Override
    public int getMAJOR() {
        return CACHE.get().get(this.diskName).getMAJOR();
    }

    @Override
    public int getMINOR() {
        return CACHE.get().get(this.diskName).getMINOR();
    }

    private static class Data {
        private long[] values;

        public Data(long[] values) {
            this.values = values;
        }

        public DiskStatsMXBean.ReadWrite getios() {
            return new DiskStatsMXBean.ReadWrite(this.values[3], this.values[7]);
        }

        public DiskStatsMXBean.ReadWrite getmerges() {
            return new DiskStatsMXBean.ReadWrite(this.values[4], this.values[8]);
        }

        public DiskStatsMXBean.ReadWrite getsectors() {
            return new DiskStatsMXBean.ReadWrite(this.values[5], this.values[9]);
        }

        public DiskStatsMXBean.ReadWrite getticks() {
            return new DiskStatsMXBean.ReadWrite(this.values[6], this.values[10]);
        }

        public long getinflight() {
            return this.values[11];
        }

        public long getio_ticks() {
            return this.values[12];
        }

        public long gettime_in_queue() {
            return this.values[13];
        }

        public int getMAJOR() {
            return (int)this.values[0];
        }

        public int getMINOR() {
            return (int)this.values[1];
        }
    }
}

