/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.time.Duration;
import java.util.List;
import net.thisptr.java.procfs.mbeans.agent.mbeans.LoadAvgMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;

public class LoadAvg
implements LoadAvgMXBean {
    private static final SingleCache<Data> CACHE = new SingleCache<Data>(Duration.ofSeconds(1L), () -> {
        Data info = new Data();
        List<String> lines = MoreFiles.readLinesAndExpectRows("/proc/loadavg", 1);
        String[] stats = lines.get(0).split(" ");
        info.load1m = Double.parseDouble(stats[0]);
        info.load5m = Double.parseDouble(stats[1]);
        info.load15m = Double.parseDouble(stats[2]);
        String[] threads = stats[3].split("/");
        info.nr_running = Integer.parseInt(threads[0]);
        info.nr_threads = Integer.parseInt(threads[1]);
        return info;
    });

    @Override
    public double getload1m() {
        return LoadAvg.CACHE.get().load1m;
    }

    @Override
    public double getload5m() {
        return LoadAvg.CACHE.get().load5m;
    }

    @Override
    public double getload15m() {
        return LoadAvg.CACHE.get().load15m;
    }

    @Override
    public long getnr_running() {
        return LoadAvg.CACHE.get().nr_running;
    }

    @Override
    public long getnr_threads() {
        return LoadAvg.CACHE.get().nr_threads;
    }

    private static class Data {
        public double load1m;
        public double load5m;
        public double load15m;
        public int nr_running;
        public int nr_threads;

        private Data() {
        }
    }
}

