/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.MemInfoMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.LongCompositeData;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class MemInfo
implements MemInfoMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(MemInfo.class);

    public Map<String, Long> parseMemInfo() throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String rawLine : MoreFiles.readLines("/proc/meminfo")) {
            Long value;
            String[] keyAndVal = rawLine.split(":", 2);
            if (keyAndVal.length != 2) {
                LOG.warn("/proc/meminfo: failed to parse line: {}", (Object)rawLine);
                continue;
            }
            String key = keyAndVal[0];
            String[] val = keyAndVal[1].trim().split(" ", 2);
            if (val.length == 2) {
                if (!val[1].trim().equals("kB")) {
                    LOG.warn("/proc/meminfo: unsupported unit \"{}\"", (Object)val[1]);
                    continue;
                }
                value = Long.valueOf(val[0]) * 1024L;
            } else if (val.length == 1) {
                value = Long.valueOf(val[0]);
            } else {
                LOG.warn("/proc/meminfo: invalid value: {}", (Object)keyAndVal[1]);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public LongCompositeData get$() throws IOException {
        return new LongCompositeData(this.parseMemInfo(), "/proc/meminfo");
    }
}

