/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.SoftIrqsMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class SoftIrqs
implements SoftIrqsMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(SoftIrqs.class);
    private static final SingleCache<Data> CACHE = new SingleCache<Data>(Duration.ofSeconds(1L), () -> {
        List<String> lines = MoreFiles.readLines("/proc/softirqs");
        Data data = new Data();
        String[] cpus = lines.get(0).trim().split(" +");
        for (int index = 0; index < cpus.length; ++index) {
            data.cpus.put(cpus[index].toLowerCase(), index);
        }
        for (int nr = 1; nr < lines.size(); ++nr) {
            String[] tokens = lines.get(nr).trim().split(":", 2);
            if (tokens.length != 2) {
                LOG.warn("/proc/softirqs: invalid line: {}", (Object)lines.get(nr));
                continue;
            }
            String name = tokens[0];
            List values = Arrays.stream(tokens[1].trim().split(" +")).map(value -> Long.parseLong(value)).collect(Collectors.toList());
            if (values.size() != data.cpus.size()) {
                LOG.warn("/proc/softirqs: unexpected number of columns in line: {}", (Object)lines.get(nr));
                continue;
            }
            data.softirqs.put(name, values);
        }
        return data;
    });
    private final String cpu;
    private final String softirq;

    public SoftIrqs(String softirq, String cpu) {
        this.softirq = softirq;
        this.cpu = cpu;
    }

    @Override
    public long getsoftirqs() {
        Data data = CACHE.get();
        Integer index = data.cpus.get(this.cpu);
        if (index == null) {
            return -1L;
        }
        List<Long> values = data.softirqs.get(this.softirq);
        if (values == null) {
            return -1L;
        }
        return values.get(index);
    }

    public static Collection<String> listCpus() {
        return SoftIrqs.CACHE.get().cpus.keySet();
    }

    public static Collection<String> listSoftIrqs() {
        return SoftIrqs.CACHE.get().softirqs.keySet();
    }

    private static class Data {
        public Map<String, Integer> cpus = new HashMap<String, Integer>();
        public Map<String, List<Long>> softirqs = new HashMap<String, List<Long>>();

        private Data() {
        }
    }
}

