/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.time.Duration;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.StatMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class Stat
implements StatMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(Stat.class);
    private static final SingleCache<Data> CACHE = new SingleCache<Data>(Duration.ofSeconds(1L), () -> {
        Data data = new Data();
        for (String line : MoreFiles.readLines("/proc/stat")) {
            String[] kv = line.split(" +");
            if (kv.length < 2) {
                LOG.warn("/proc/stat: failed to parse line: {}", (Object)line);
                continue;
            }
            String key = kv[0];
            long value = Long.parseLong(kv[1]);
            switch (key) {
                case "intr": {
                    data.intr = value;
                    break;
                }
                case "ctxt": {
                    data.ctxt = value;
                    break;
                }
                case "processes": {
                    data.processes = value;
                    break;
                }
                case "procs_running": {
                    data.procs_running = value;
                    break;
                }
                case "procs_blocked": {
                    data.procs_blocked = value;
                    break;
                }
                case "softirq": {
                    data.softirq = value;
                    break;
                }
            }
        }
        return data;
    });

    @Override
    public long getsoftirq() {
        return Stat.CACHE.get().softirq;
    }

    @Override
    public long getprocs_blocked() {
        return Stat.CACHE.get().procs_blocked;
    }

    @Override
    public long getprocs_running() {
        return Stat.CACHE.get().procs_running;
    }

    @Override
    public long getprocesses() {
        return Stat.CACHE.get().processes;
    }

    @Override
    public long getctxt() {
        return Stat.CACHE.get().ctxt;
    }

    @Override
    public long getintr() {
        return Stat.CACHE.get().intr;
    }

    private static class Data {
        public long softirq = -1L;
        public long intr = -1L;
        public long procs_blocked = -1L;
        public long procs_running = -1L;
        public long processes = -1L;
        public long ctxt = -1L;

        private Data() {
        }
    }
}

