/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.Stat_CpuMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class Stat_Cpu
implements Stat_CpuMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(Stat_Cpu.class);
    private static final SingleCache<Map<String, CpuUsage>> CACHE = new SingleCache<Map>(Duration.ofSeconds(1L), () -> {
        HashMap<String, CpuUsage> usages = new HashMap<String, CpuUsage>();
        for (String line : MoreFiles.readLines("/proc/stat")) {
            String[] kv = line.split(" +");
            if (!kv[0].startsWith("cpu")) continue;
            String cpu = kv[0];
            if (kv.length != 11) {
                LOG.warn("/proc/stat: unexpected number of columns in line: {}", (Object)line);
                continue;
            }
            CpuUsage usage = new CpuUsage();
            usage.user = Long.parseLong(kv[1]);
            usage.nice = Long.parseLong(kv[2]);
            usage.system = Long.parseLong(kv[3]);
            usage.idle = Long.parseLong(kv[4]);
            usage.iowait = Long.parseLong(kv[5]);
            usage.irq = Long.parseLong(kv[6]);
            usage.softirq = Long.parseLong(kv[7]);
            usage.steal = Long.parseLong(kv[8]);
            usage.guest = Long.parseLong(kv[9]);
            usage.guest_nice = Long.parseLong(kv[10]);
            usages.put(cpu, usage);
        }
        return usages;
    });
    private final String cpu;

    public Stat_Cpu(String cpu) {
        this.cpu = cpu;
    }

    @Override
    public long getcpu_user() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).user;
    }

    @Override
    public long getcpu_nice() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).nice;
    }

    @Override
    public long getcpu_system() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).system;
    }

    @Override
    public long getcpu_idle() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).idle;
    }

    @Override
    public long getcpu_iowait() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).iowait;
    }

    @Override
    public long getcpu_irq() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).irq;
    }

    @Override
    public long getcpu_softirq() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).softirq;
    }

    @Override
    public long getcpu_steal() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).steal;
    }

    @Override
    public long getcpu_guest() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).guest;
    }

    @Override
    public long getcpu_guest_nice() {
        return Stat_Cpu.CACHE.get().get((Object)this.cpu).guest_nice;
    }

    public static Set<String> listCpus() {
        return CACHE.get().keySet();
    }

    private static class CpuUsage {
        public long user;
        public long nice;
        public long system;
        public long idle;
        public long iowait;
        public long irq;
        public long softirq;
        public long steal;
        public long guest;
        public long guest_nice;

        private CpuUsage() {
        }
    }
}

