/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans.cgroup;

import java.io.File;
import java.io.IOException;
import net.thisptr.java.procfs.mbeans.agent.mbeans.cgroup.CpuMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.LongCompositeData;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;

public class Cpu
implements CpuMXBean {
    private final File cgroupfs = new File("/sys/fs/cgroup");

    private long readAsLong(String path) {
        try {
            return MoreFiles.readAsLong(new File(this.cgroupfs, path).toPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getCfsQuotaUs() {
        return this.readAsLong("cpu/cpu.cfs_quota_us");
    }

    @Override
    public long getCfsPeriodUs() {
        return this.readAsLong("cpu/cpu.cfs_period_us");
    }

    @Override
    public long getShares() {
        return this.readAsLong("cpu/cpu.shares");
    }

    @Override
    public LongCompositeData getStat() {
        try {
            return MoreFiles.readAsLongMap(new File(this.cgroupfs, "cpu/cpu.stat").toPath(), " ");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

