/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans.net.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.misc.LongCompositeData;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class SnmpStyleReader {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpStyleReader.class);

    public static Map<String, LongCompositeData> readFile(String path) {
        HashMap<String, List> categories = new HashMap<String, List>();
        for (String line : MoreFiles.readLines(path)) {
            String[] parts = line.split(": ", 2);
            if (parts.length != 2) {
                throw new IllegalStateException("Unparseable line in " + path);
            }
            String category2 = parts[0];
            categories.computeIfAbsent(category2, __ -> new ArrayList()).add(parts[1]);
        }
        HashMap<String, LongCompositeData> results = new HashMap<String, LongCompositeData>();
        categories.forEach((category, lines) -> {
            String[] values;
            if (lines.size() != 2) {
                LOG.warn("{}: failed to parse line", (Object)path);
                return;
            }
            String[] columns = ((String)lines.get(0)).split(" ");
            if (columns.length != (values = ((String)lines.get(1)).split(" ")).length) {
                LOG.warn("{}: failed to parse line", (Object)path);
                return;
            }
            HashMap<String, Long> fields = new HashMap<String, Long>();
            for (int i = 0; i < columns.length; ++i) {
                fields.put(columns[i], Long.valueOf(values[i]));
            }
            results.put((String)category, new LongCompositeData(fields, path));
        });
        return results;
    }
}

