/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans.self;

import java.time.Duration;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.mbeans.self.ProcessIoMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class ProcessIo
implements ProcessIoMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessIo.class);
    private static final SingleCache<TaskIoAccounting> CACHE = new SingleCache<TaskIoAccounting>(Duration.ofSeconds(1L), () -> {
        TaskIoAccounting acct = new TaskIoAccounting();
        block18: for (String line : MoreFiles.readLines("/proc/self/io")) {
            String[] kv = line.split(": +");
            if (kv.length != 2) {
                LOG.warn("/proc/self/io: failed to parse line: {}", (Object)line);
                continue;
            }
            long value = Long.parseLong(kv[1]);
            switch (kv[0]) {
                case "rchar": {
                    acct.rchar = value;
                    continue block18;
                }
                case "wchar": {
                    acct.wchar = value;
                    continue block18;
                }
                case "syscr": {
                    acct.syscr = value;
                    continue block18;
                }
                case "syscw": {
                    acct.syscw = value;
                    continue block18;
                }
                case "read_bytes": {
                    acct.read_bytes = value;
                    continue block18;
                }
                case "write_bytes": {
                    acct.write_bytes = value;
                    continue block18;
                }
                case "cancelled_write_bytes": {
                    acct.cancelled_write_bytes = value;
                    continue block18;
                }
            }
            LOG.warn("/proc/self/io: unsupported key: {}", (Object)kv[0]);
        }
        return acct;
    });

    @Override
    public long getrchar() {
        return ProcessIo.CACHE.get().rchar;
    }

    @Override
    public long getwchar() {
        return ProcessIo.CACHE.get().wchar;
    }

    @Override
    public long getsyscr() {
        return ProcessIo.CACHE.get().syscr;
    }

    @Override
    public long getsyscw() {
        return ProcessIo.CACHE.get().syscw;
    }

    @Override
    public long getread_bytes() {
        return ProcessIo.CACHE.get().read_bytes;
    }

    @Override
    public long getwrite_bytes() {
        return ProcessIo.CACHE.get().write_bytes;
    }

    @Override
    public long getcancelled_write_bytes() {
        return ProcessIo.CACHE.get().cancelled_write_bytes;
    }

    private static class TaskIoAccounting {
        public long rchar = -1L;
        public long wchar = -1L;
        public long syscr = -1L;
        public long syscw = -1L;
        public long read_bytes = -1L;
        public long write_bytes = -1L;
        public long cancelled_write_bytes = -1L;

        private TaskIoAccounting() {
        }
    }
}

