/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.mbeans.self;

import java.time.Duration;
import java.util.List;
import net.thisptr.java.procfs.mbeans.agent.mbeans.self.ProcessStatmMXBean;
import net.thisptr.java.procfs.mbeans.agent.misc.MoreFiles;
import net.thisptr.java.procfs.mbeans.agent.misc.SingleCache;

public class ProcessStatm
implements ProcessStatmMXBean {
    private static SingleCache<Data> CACHE = new SingleCache<Data>(Duration.ofSeconds(1L), () -> {
        List<String> lines = MoreFiles.readLinesAndExpectRows("/proc/self/statm", 1);
        String[] values = lines.get(0).split(" ");
        if (values.length < 7) {
            throw new RuntimeException("/proc/self/statm: unable to parse line: " + lines.get(0));
        }
        Data data = new Data();
        data.size = Long.parseLong(values[0]);
        data.resident = Long.parseLong(values[1]);
        data.shared = Long.parseLong(values[2]);
        data.text = Long.parseLong(values[3]);
        data.data = Long.parseLong(values[5]);
        return data;
    });

    @Override
    public long getsize() {
        return ProcessStatm.CACHE.get().size;
    }

    @Override
    public long getresident() {
        return ProcessStatm.CACHE.get().resident;
    }

    @Override
    public long getshared() {
        return ProcessStatm.CACHE.get().shared;
    }

    @Override
    public long gettext() {
        return ProcessStatm.CACHE.get().text;
    }

    @Override
    public long getdata() {
        return ProcessStatm.CACHE.get().data;
    }

    private static class Data {
        public long size;
        public long resident;
        public long shared;
        public long text;
        public long data;

        private Data() {
        }
    }
}

