/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.misc;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.thisptr.java.procfs.mbeans.agent.LoggerFactory;
import net.thisptr.java.procfs.mbeans.agent.misc.LongCompositeData;
import net.thisptr.java.procfs.mbeans.agent.shade.org.slf4j.Logger;

public class MoreFiles {
    private static final Logger LOG = LoggerFactory.getLogger(MoreFiles.class);

    public static String readAsString(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static long readAsLong(Path path) throws NumberFormatException, IOException {
        return Long.parseLong(MoreFiles.readAsString(path).trim());
    }

    public static LongCompositeData readAsLongMap(Path path, String sepText) throws IOException {
        Pattern sep = Pattern.compile(Pattern.quote(sepText));
        HashMap<String, Long> data = new HashMap<String, Long>();
        for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
            String[] tokens = sep.split(line, 2);
            if (tokens.length != 2) {
                LOG.warn("{}: failed to parse line: {}", (Object)path.toString(), (Object)line.trim());
                continue;
            }
            try {
                String key = tokens[0].trim();
                long value = Long.parseLong(tokens[1]);
                data.put(key, value);
            }
            catch (NumberFormatException e) {
                LOG.warn("{}: failed to parse line: {}", (Object)path.toString(), (Object)line.trim());
            }
        }
        return new LongCompositeData(data, path.toString());
    }

    public static List<String> readLines(String path) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            return lines;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLinesAndExpectRows(String path, int rows) {
        List<String> lines = MoreFiles.readLines(path);
        if (lines.size() != rows) {
            throw new IllegalStateException(path + ": expected " + rows + " lines");
        }
        return lines;
    }
}

