/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.procfs.mbeans.agent.misc;

import java.time.Duration;
import java.util.function.Supplier;

public class SingleCache<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final Duration timeToLive;
    private Data<T> data;

    public SingleCache(Duration timeToLive, Supplier<T> supplier) {
        this.timeToLive = timeToLive;
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long now = System.currentTimeMillis();
        SingleCache singleCache = this;
        synchronized (singleCache) {
            if (this.data != null && now < this.data.expireAt) {
                return this.data.data;
            }
            this.data = new Data<T>(this.supplier.get(), now + this.timeToLive.toMillis());
            return this.data.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SingleCache singleCache = this;
        synchronized (singleCache) {
            this.data = null;
        }
    }

    private static class Data<T> {
        public final long expireAt;
        public final T data;

        public Data(T data, long expireAt) {
            this.data = data;
            this.expireAt = expireAt;
        }
    }
}

