/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.ant;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.thucydides.ant.util.PathProcessor;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ThucydidesReportingTask
extends Task {
    public String outputDirectory;
    public String sourceDirectory;
    public String issueTrackerUrl;
    public String jiraUrl;
    public String jiraUsername;
    public String jiraPassword;
    public String jiraProject;
    private PathProcessor pathProcessor = new PathProcessor();

    public Path getSourceDirectoryFile() {
        return Paths.get(this.pathProcessor.normalize(this.sourceDirectory), new String[0]);
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public void setJiraUrl(String jiraUrl) {
        this.jiraUrl = jiraUrl;
    }

    public void setJiraUsername(String jiraUsername) {
        this.jiraUsername = jiraUsername;
    }

    public void setJiraPassword(String jiraPassword) {
        this.jiraPassword = jiraPassword;
    }

    public void setJiraProject(String jiraProject) {
        this.jiraProject = jiraProject;
    }

    private String normalizedPath(String directoryPath) {
        return this.pathProcessor.normalize(directoryPath);
    }

    public Path getOutputDirectoryFile() {
        return Paths.get(this.normalizedPath(this.outputDirectory), new String[0]);
    }

    public void execute() {
        this.log("Generating Thucydides reports");
        try {
            this.prepareDirectories();
            HtmlAggregateStoryReporter reporter = new HtmlAggregateStoryReporter(this.getProject().getName());
            reporter.setSourceDirectory(this.getSourceDirectoryFile().toFile());
            reporter.setOutputDirectory(this.getOutputDirectoryFile().toFile());
            reporter.setIssueTrackerUrl(this.issueTrackerUrl);
            reporter.setJiraUrl(this.jiraUrl);
            reporter.setJiraProject(this.jiraProject);
            reporter.setJiraUsername(this.jiraUsername);
            reporter.setJiraPassword(this.jiraPassword);
            reporter.generateReportsForTestResultsFrom(this.sourceOfTestResult().toFile());
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void prepareDirectories() throws IOException {
        if (Files.notExists(this.getOutputDirectoryFile(), new LinkOption[0])) {
            Files.createDirectories(this.getOutputDirectoryFile(), new FileAttribute[0]);
        }
    }

    private Path sourceOfTestResult() {
        if (this.getSourceDirectoryFile() != null && Files.exists(this.getSourceDirectoryFile(), new LinkOption[0])) {
            return this.getSourceDirectoryFile();
        }
        return this.getOutputDirectoryFile();
    }
}

