/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.browsermob.fixtureservices;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.thucydides.browsermob.fixtureservices.BrowserMobSystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.browsermob.proxy.ProxyServer;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserMobFixtureService
implements FixtureService {
    public static final int DEFAULT_PORT = 5555;
    private static final int PORT_RANGE = 1000;
    private static final int MIN_AVAILABLE_PORT = 49152;
    private static final int MAX_AVAILABLE_PORT = 50152;
    private final EnvironmentVariables environmentVariables;
    private int port = 0;
    private ThreadLocal<ProxyServer> threadLocalproxyServer = new ThreadLocal();

    public BrowserMobFixtureService() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public BrowserMobFixtureService(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setup() throws FixtureException {
        if (this.useBrowserMobProxyManager()) {
            try {
                this.initializeProxy(this.getAvailablePort());
            }
            catch (Exception e) {
                throw new FixtureException("Failed to initialize proxy", (Throwable)e);
            }
        }
    }

    protected ProxyServer getProxyServer() {
        return this.threadLocalproxyServer.get();
    }

    private void initializeProxy(int port) throws Exception {
        this.setPort(port);
        this.threadLocalproxyServer.set(new ProxyServer(port));
        this.threadLocalproxyServer.get().start();
    }

    public void shutdown() {
        if (this.threadLocalproxyServer.get() != null) {
            try {
                this.threadLocalproxyServer.get().stop();
            }
            catch (Exception e) {
                throw new FixtureException("Could not shut down BrowserMob proxy", (Throwable)e);
            }
            this.threadLocalproxyServer.remove();
        }
    }

    public void addCapabilitiesTo(DesiredCapabilities capabilities) {
        if (!this.proxyServerRunning()) {
            this.setup();
        }
        try {
            capabilities.setCapability("proxy", (Object)this.threadLocalproxyServer.get().seleniumProxy());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean proxyServerRunning() {
        return this.threadLocalproxyServer.get() != null;
    }

    private boolean useBrowserMobProxyManager() {
        String browserMobFilter = this.environmentVariables.getProperty((Enum)BrowserMobSystemProperties.BROWSER_MOB_FILTER);
        return StringUtils.isEmpty((CharSequence)browserMobFilter) || this.shouldActivateBrowserMobWithDriver(browserMobFilter, this.environmentVariables);
    }

    private boolean shouldActivateBrowserMobWithDriver(String filter, EnvironmentVariables environmentVariables) {
        String currentDriver = environmentVariables.getProperty((Enum)ThucydidesSystemProperty.DRIVER);
        ArrayList allowedBrowsers = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)filter.toLowerCase()));
        return StringUtils.isEmpty((CharSequence)currentDriver) || allowedBrowsers.contains(currentDriver.toLowerCase());
    }

    private void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    protected int getAvailablePort() {
        int defaultPort = this.environmentVariables.getPropertyAsInteger((Enum)BrowserMobSystemProperties.BROWSER_MOB_PROXY, Integer.valueOf(5555));
        if (this.isAvailable(defaultPort)) {
            return defaultPort;
        }
        return this.nextAvailablePort(49152);
    }

    private int nextAvailablePort(int portNumber) {
        if (portNumber > 50152) {
            throw new IllegalStateException("No available ports found");
        }
        if (this.isAvailable(portNumber)) {
            return portNumber;
        }
        return this.nextAvailablePort(portNumber + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAvailable(int portNumber) {
        ServerSocket socket = null;
        boolean available = false;
        try {
            socket = new ServerSocket(portNumber);
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ignored) {}
            }
        }
        return available;
    }
}

