/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.junit.rules;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.WebdriverSystemProperty;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SaveWebdriverSystemPropertiesRule
implements MethodRule {
    private static final Map<String, String> ORIGINAL_WEB_DRIVER_PROPERTY_VALUES = new HashMap<String, String>();

    public SaveWebdriverSystemPropertiesRule() {
        for (WebdriverSystemProperty property : WebdriverSystemProperty.values()) {
            SaveWebdriverSystemPropertiesRule.savePropertyValueFor(property);
        }
    }

    private static void savePropertyValueFor(WebdriverSystemProperty property) {
        String propertyName = property.getPropertyName();
        String currentValue = System.getProperty(propertyName);
        if (currentValue != null) {
            ORIGINAL_WEB_DRIVER_PROPERTY_VALUES.put(propertyName, currentValue);
        }
    }

    public Statement apply(final Statement statement, FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                catch (Throwable exception) {
                    throw exception;
                }
                finally {
                    this.restoreOldSystemProperties();
                }
            }

            private void restoreOldSystemProperties() {
                for (WebdriverSystemProperty property : WebdriverSystemProperty.values()) {
                    this.restorePropertyValueFor(property);
                }
            }

            private void restorePropertyValueFor(WebdriverSystemProperty property) {
                String propertyName = property.getPropertyName();
                String originalValue = (String)ORIGINAL_WEB_DRIVER_PROPERTY_VALUES.get(propertyName);
                if (originalValue != null) {
                    System.setProperty(propertyName, originalValue);
                } else {
                    System.clearProperty(propertyName);
                }
            }
        };
    }
}

