/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptanceTestRun {
    private String title;
    private Set<String> testedRequirement = new HashSet<String>();
    private final List<TestStep> testSteps = new ArrayList<TestStep>();

    public AcceptanceTestRun() {
    }

    public AcceptanceTestRun(String title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void testsRequirement(String requirement) {
        Preconditions.checkNotNull((Object)requirement);
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public TestResult getResult() {
        List<TestResult> allTestResults = this.getCurrentTestResults();
        if (allTestResults.contains((Object)TestResult.FAILURE)) {
            return TestResult.FAILURE;
        }
        if (allTestResults.contains((Object)TestResult.PENDING)) {
            return TestResult.PENDING;
        }
        if (this.containsOnly(allTestResults, TestResult.IGNORED)) {
            return TestResult.IGNORED;
        }
        return TestResult.SUCCESS;
    }

    public void recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        Preconditions.checkNotNull((Object)((Object)step.getResult()), (Object)"The test step result was not defined");
        this.testSteps.add(step);
    }

    private boolean containsOnly(List<TestResult> testResults, TestResult value) {
        for (TestResult result : testResults) {
            if (result == value) continue;
            return false;
        }
        return true;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getSuccessCount() {
        return Lambda.select(this.testSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSuccessful())).size();
    }

    public Integer getFailureCount() {
        return Lambda.select(this.testSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isFailure())).size();
    }

    public Integer getIgnoredCount() {
        return Lambda.select(this.testSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isIgnored())).size();
    }

    public Integer getSkippedCount() {
        return Lambda.select(this.testSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSkipped())).size();
    }

    public Integer getPendingCount() {
        return Lambda.select(this.testSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Set<String> getAllTestedRequirements() {
        HashSet<String> allTestedRequirements = new HashSet<String>();
        allTestedRequirements.addAll(this.getTestedRequirements());
        for (TestStep step : this.getTestSteps()) {
            allTestedRequirements.addAll(step.getTestedRequirements());
        }
        return allTestedRequirements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

