/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStep {
    private String description;
    private File screenshot;
    private String screenshotPath;
    private TestResult result;
    private String errorMessage;
    private Throwable cause;
    private Set<String> testedRequirement = new HashSet<String>();

    public TestStep() {
    }

    public TestStep(String description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void testsRequirement(String requirement) {
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public void setScreenshot(File screenshot) {
        this.screenshot = screenshot;
    }

    public void setScreenshotPath(String screenshotPath) {
        this.screenshotPath = screenshotPath;
    }

    public String getScreenshotPath() {
        return this.screenshotPath;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void failedWith(String message, Throwable e) {
        this.errorMessage = message;
        this.cause = e;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public TestResult getResult() {
        return this.result;
    }

    public File getScreenshot() {
        return this.screenshot;
    }

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Throwable getException() {
        return this.cause;
    }
}

