/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.thucydides.core.annotations.At;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

public abstract class PageObject {
    private static final int TIMEOUT = 5;
    private static final String OPTIONAL_PARAMS = "/?(\\?.*)?";
    private static final Map<String, String> MACROS = new HashMap<String, String>();
    private WebDriver driver;
    private List<Pattern> matchingPageExpressions;

    public PageObject(WebDriver driver) {
        MACROS.put("#HOST", "https?://[^/]+");
        this.matchingPageExpressions = new ArrayList<Pattern>();
        AjaxElementLocatorFactory finder = new AjaxElementLocatorFactory(driver, 5);
        this.driver = driver;
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)this);
        this.fetchMatchingPageExpressions();
    }

    private void fetchMatchingPageExpressions() {
        At compatibleWithAnnotation = this.getClass().getAnnotation(At.class);
        if (compatibleWithAnnotation != null) {
            if (this.valueIsDefinedFor(compatibleWithAnnotation)) {
                this.worksWithUrlPattern(compatibleWithAnnotation.value());
            } else {
                this.worksWithUrlPatternList(compatibleWithAnnotation.urls());
            }
        }
    }

    private void worksWithUrlPatternList(String[] urls) {
        for (String url : urls) {
            this.worksWithUrlPattern(url);
        }
    }

    private boolean valueIsDefinedFor(At compatibleWithAnnotation) {
        return compatibleWithAnnotation.value() != null && compatibleWithAnnotation.value().length() > 0;
    }

    private void worksWithUrlPattern(String urlPattern) {
        String processedUrlPattern = this.substituteMacrosIn(urlPattern);
        this.matchingPageExpressions.add(Pattern.compile(processedUrlPattern));
    }

    private String substituteMacrosIn(String urlPattern) {
        String patternWithExpandedMacros = urlPattern;
        for (String macro : MACROS.keySet()) {
            String expanded = MACROS.get(macro);
            patternWithExpandedMacros = patternWithExpandedMacros.replaceAll(macro, expanded);
        }
        patternWithExpandedMacros = patternWithExpandedMacros + OPTIONAL_PARAMS;
        return patternWithExpandedMacros;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        if (this.thereAreNoPatternsDefined()) {
            return true;
        }
        return this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        boolean pageWorksHere = false;
        for (Pattern pattern : this.matchingPageExpressions) {
            if (!this.urlIsCompatibleWithThisPattern(currentUrl, pattern)) continue;
            pageWorksHere = true;
            break;
        }
        return pageWorksHere;
    }

    private boolean thereAreNoPatternsDefined() {
        return this.matchingPageExpressions.isEmpty();
    }

    private boolean urlIsCompatibleWithThisPattern(String currentUrl, Pattern pattern) {
        return pattern.matcher(currentUrl).matches();
    }
}

