/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import net.thucydides.core.WebdriverSystemProperty;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WrongPageException;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pages {
    private final WebDriver driver;
    private String defaultBaseUrl;

    public Pages(WebDriver driver) {
        this.driver = driver;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    private String getBaseUrl() {
        String systemDefinedBaseUrl = System.getProperty(WebdriverSystemProperty.BASE_URL.getPropertyName());
        if (systemDefinedBaseUrl != null) {
            return systemDefinedBaseUrl;
        }
        return this.defaultBaseUrl;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void start() {
        Preconditions.checkNotNull((Object)this.driver);
        String homeUrl = this.getBaseUrl();
        this.driver.get(homeUrl);
    }

    public PageObject currentPageAt(Class<? extends PageObject> pageObjectClass) {
        String currentUrl;
        PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
        if (!pageCandidate.compatibleWithUrl(currentUrl = this.driver.getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        return pageCandidate;
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.driver.getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageException e) {
            return false;
        }
    }

    private PageObject getCurrentPageOfType(Class<? extends PageObject> pageObjectClass) {
        PageObject currentPage = null;
        try {
            Class[] constructorArgs = new Class[]{WebDriver.class};
            Constructor<? extends PageObject> constructor = pageObjectClass.getConstructor(constructorArgs);
            currentPage = constructor.newInstance(this.driver);
            currentPage.setDriver(this.driver);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        return currentPage;
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + pageObjectClass + "\n" + "I was at the URL " + this.driver.getCurrentUrl();
        throw new WrongPageException(errorDetails);
    }
}

