/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import net.thucydides.core.model.AcceptanceTestRun;
import org.modeshape.common.text.Inflector;

public class ReportNamer {
    private final Inflector inflector = Inflector.getInstance();
    private ReportType type;

    public ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(AcceptanceTestRun testRun) {
        String testCaseNameWithUnderscores = this.inflector.underscore(testRun.getTitle(), new char[0]);
        String lowerCaseTestCaseName = testCaseNameWithUnderscores.toLowerCase();
        String lowerCaseTestCaseNameWithUnderscores = lowerCaseTestCaseName.replaceAll("\\s", "_");
        return lowerCaseTestCaseNameWithUnderscores + "." + this.type.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        XML("xml"),
        HTML("html");

        private String suffix;

        private ReportType(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

