/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.regex.Pattern;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportNamer;
import net.thucydides.core.resources.ResourceList;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class HtmlAcceptanceTestReporter
implements AcceptanceTestReporter {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_RESOURCE_DIRECTORY = "/report-resources";
    private File outputDirectory;
    private ReportNamer reportNamer = new ReportNamer(ReportNamer.ReportType.HTML);
    private String resourceDirectory = "/report-resources";
    private VelocityEngine ve = new VelocityEngine();

    public HtmlAcceptanceTestReporter() {
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.addProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.init();
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public File generateReportFor(AcceptanceTestRun testRun) throws IOException {
        Preconditions.checkNotNull((Object)this.outputDirectory);
        String htmlContents = "";
        Template template = this.getTemplate();
        VelocityContext context = new VelocityContext();
        context.put("testrun", (Object)testRun);
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        htmlContents = sw.toString();
        String reportFilename = this.reportNamer.getNormalizedTestNameFor(testRun);
        File report = new File(this.getOutputDirectory(), reportFilename);
        FileUtils.writeStringToFile((File)report, (String)htmlContents);
        this.copyHTMLResourcesTo(this.getOutputDirectory());
        return report;
    }

    private void copyHTMLResourcesTo(File targetDirectory) throws IOException {
        Pattern resourcePattern = this.allFilesInDirectory(this.resourceDirectory);
        Collection<String> reportResources = ResourceList.getResources(resourcePattern);
        for (String resourcePath : reportResources) {
            if (this.resourceIsAFile(resourcePath)) {
                this.copyFileToTargetDirectory(resourcePath, targetDirectory);
                continue;
            }
            this.copyFileFromClasspathToTargetDirectory(resourcePath, targetDirectory);
        }
    }

    private Pattern allFilesInDirectory(String directory) {
        return Pattern.compile(".*" + directory + "/.*");
    }

    private void copyFileToTargetDirectory(String resourcePath, File targetDirectory) throws IOException {
        FileUtils.copyFileToDirectory((File)new File(resourcePath), (File)targetDirectory);
    }

    private void copyFileFromClasspathToTargetDirectory(String resourcePath, File targetDirectory) throws IOException {
        int bytesRead;
        File resourceOnClasspath = new File(resourcePath);
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        File destinationFile = new File(targetDirectory, resourceOnClasspath.getName());
        FileOutputStream out = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    private boolean resourceIsAFile(String resourcePath) {
        return resourcePath.startsWith("/");
    }

    private Template getTemplate() {
        return this.ve.getTemplate("velocity/default.vm");
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

