/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptanceTestRunConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return AcceptanceTestRun.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        AcceptanceTestRun testRun = (AcceptanceTestRun)value;
        Preconditions.checkNotNull((Object)testRun, (Object)"The test run was null - WTF?");
        writer.addAttribute("title", testRun.getTitle());
        writer.addAttribute("steps", Integer.toString(testRun.getTestSteps().size()));
        writer.addAttribute("successful", Integer.toString(testRun.getSuccessCount()));
        writer.addAttribute("failures", Integer.toString(testRun.getFailureCount()));
        writer.addAttribute("skipped", Integer.toString(testRun.getSkippedCount()));
        writer.addAttribute("ignored", Integer.toString(testRun.getIgnoredCount()));
        writer.addAttribute("pending", Integer.toString(testRun.getPendingCount()));
        writer.addAttribute("result", testRun.getResult().toString());
        this.addRequirementsTo(writer, testRun.getTestedRequirements());
        List<TestStep> steps = testRun.getTestSteps();
        for (TestStep step : steps) {
            writer.startNode("test-step");
            this.writeResult(writer, step);
            this.addRequirementsTo(writer, step.getTestedRequirements());
            this.writeDescription(writer, step);
            this.writeErrorForFailingTest(writer, step);
            this.writeScreenshotIfPresent(writer, step);
            writer.endNode();
        }
    }

    private void addRequirementsTo(HierarchicalStreamWriter writer, Set<String> set) {
        if (!set.isEmpty()) {
            writer.startNode("requirements");
            for (String requirement : set) {
                writer.startNode("requirement");
                writer.setValue(requirement);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeErrorForFailingTest(HierarchicalStreamWriter writer, TestStep step) {
        if (step.isFailure().booleanValue()) {
            this.writeErrorMessageAndException(writer, step);
        }
    }

    private void writeErrorMessageAndException(HierarchicalStreamWriter writer, TestStep step) {
        if (step.getErrorMessage() != null) {
            this.writeErrorMessageNode(writer, step.getErrorMessage());
            if (step.getException() != null) {
                this.writeExceptionNode(writer, step.getException());
            }
        }
    }

    private void writeExceptionNode(HierarchicalStreamWriter writer, Throwable cause) {
        writer.startNode("exception");
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stringWriter));
        writer.setValue(stringWriter.toString());
        writer.endNode();
    }

    private void writeErrorMessageNode(HierarchicalStreamWriter writer, String errorMessage) {
        writer.startNode("error");
        writer.setValue(errorMessage);
        writer.endNode();
    }

    private void writeScreenshotIfPresent(HierarchicalStreamWriter writer, TestStep step) {
        if (step.getScreenshot() != null) {
            writer.startNode("screenshot");
            writer.setValue(step.getScreenshot().getName());
            writer.endNode();
        }
    }

    private void writeResult(HierarchicalStreamWriter writer, TestStep step) {
        writer.addAttribute("result", step.getResult().toString());
    }

    private void writeDescription(HierarchicalStreamWriter writer, TestStep step) {
        writer.startNode("description");
        writer.setValue(step.getDescription());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        AcceptanceTestRun testRun = new AcceptanceTestRun();
        testRun.setTitle(reader.getAttribute("title"));
        this.readChildren(reader, testRun);
        return testRun;
    }

    private void readChildren(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals("test-step")) {
                this.readTestStep(reader, testRun);
            } else if (childNode.equals("requirements")) {
                this.readTestRunRequirements(reader, testRun);
            }
            reader.moveUp();
        }
    }

    private void readTestRunRequirements(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            testRun.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStepRequirements(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            step.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStep(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        TestStep step = new TestStep();
        String testResultValue = reader.getAttribute("result");
        TestResult result = TestResult.valueOf(testResultValue);
        step.setResult(result);
        this.readTestStepChildren(reader, step);
        testRun.recordStep(step);
    }

    private void readTestStepChildren(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals("description")) {
                step.setDescription(reader.getValue());
            } else if (childNode.equals("requirements")) {
                this.readTestStepRequirements(reader, step);
            } else if (childNode.equals("screenshot")) {
                step.setScreenshotPath(reader.getValue());
            }
            reader.moveUp();
        }
    }
}

