/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportNamer;
import net.thucydides.core.reports.xml.AcceptanceTestRunConverter;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAcceptanceTestReporter
implements AcceptanceTestReporter {
    private File outputDirectory;
    private ReportNamer reportNamer = new ReportNamer(ReportNamer.ReportType.XML);

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public File generateReportFor(AcceptanceTestRun testRun) throws IOException {
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", AcceptanceTestRun.class);
        xstream.registerConverter((Converter)new AcceptanceTestRunConverter());
        String xmlContents = xstream.toXML((Object)testRun);
        String reportFilename = this.reportNamer.getNormalizedTestNameFor(testRun);
        File report = new File(this.getOutputDirectory(), reportFilename);
        FileUtils.writeStringToFile((File)report, (String)xmlContents);
        return report;
    }

    public AcceptanceTestRun loadReportFrom(File reportFile) throws IOException {
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", AcceptanceTestRun.class);
        xstream.registerConverter((Converter)new AcceptanceTestRunConverter());
        FileInputStream input = new FileInputStream(reportFile);
        return (AcceptanceTestRun)xstream.fromXML((InputStream)input);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<AcceptanceTestRun> loadAllReportsFrom(File reportsDirectory) throws IOException {
        File[] reportFiles;
        ArrayList<AcceptanceTestRun> acceptanceTests = new ArrayList<AcceptanceTestRun>();
        for (File reportFile : reportFiles = this.getAllXMLFilesFrom(reportsDirectory)) {
            AcceptanceTestRun testRun = this.loadReportFrom(reportFile);
            acceptanceTests.add(testRun);
        }
        return acceptanceTests;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        File[] reportFiles = reportsDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File file, String filename) {
                return filename.toLowerCase().endsWith(".xml");
            }
        });
        return reportFiles;
    }
}

