/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.io.IOException;
import net.thucydides.core.screenshots.ScreenshotSequence;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class Photographer {
    private final TakesScreenshot driver;
    private final File targetDirectory;
    private final ScreenshotSequence screenshotSequence;
    private static final ScreenshotSequence DEFAULT_SCREENSHOT_SEQUENCE = new ScreenshotSequence();

    public Photographer(TakesScreenshot driver, File targetDirectory) {
        this.driver = driver;
        this.targetDirectory = targetDirectory;
        this.screenshotSequence = DEFAULT_SCREENSHOT_SEQUENCE;
    }

    protected long nextScreenshotNumber() {
        return this.screenshotSequence.next();
    }

    private String nextScreenshotName(String prefix) {
        long nextScreenshotNumber = this.nextScreenshotNumber();
        return prefix + nextScreenshotNumber + ".png";
    }

    public File takeScreenshot(String prefix) throws IOException {
        File screenshot = (File)this.driver.getScreenshotAs(OutputType.FILE);
        File savedScreenshot = new File(this.targetDirectory, this.nextScreenshotName(prefix));
        FileUtils.copyFile((File)screenshot, (File)savedScreenshot);
        return savedScreenshot;
    }
}

