/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.junit.rules;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SaveWebdriverSystemPropertiesRule
implements MethodRule {
    private static final Map<String, String> ORIGINAL_WEB_DRIVER_PROPERTY_VALUES = new HashMap<String, String>();

    public SaveWebdriverSystemPropertiesRule() {
        for (ThucydidesSystemProperty property : ThucydidesSystemProperty.values()) {
            SaveWebdriverSystemPropertiesRule.savePropertyValueFor(property);
        }
    }

    private static void savePropertyValueFor(ThucydidesSystemProperty property) {
        String propertyName = property.getPropertyName();
        String currentValue = System.getProperty(propertyName);
        if (currentValue != null) {
            ORIGINAL_WEB_DRIVER_PROPERTY_VALUES.put(propertyName, currentValue);
        }
    }

    public Statement apply(Statement statement, FrameworkMethod method, Object target) {
        return new RestorePropertiesStatement(statement);
    }

    private static final class RestorePropertiesStatement
    extends Statement {
        private final Statement statement;

        private RestorePropertiesStatement(Statement statement) {
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            try {
                this.statement.evaluate();
            }
            catch (Throwable exception) {
                throw exception;
            }
            finally {
                this.restoreOldSystemProperties();
            }
        }

        private void restoreOldSystemProperties() {
            for (ThucydidesSystemProperty property : ThucydidesSystemProperty.values()) {
                this.restorePropertyValueFor(property);
            }
        }

        private void restorePropertyValueFor(ThucydidesSystemProperty property) {
            String propertyName = property.getPropertyName();
            String originalValue = (String)ORIGINAL_WEB_DRIVER_PROPERTY_VALUES.get(propertyName);
            if (originalValue != null) {
                System.setProperty(propertyName, originalValue);
            } else {
                System.clearProperty(propertyName);
            }
        }
    }
}

