/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.model.UserStory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptanceTestRun {
    private String title;
    private String methodName;
    private UserStory userStory;
    private long duration;
    private long startTime;
    private Set<String> testedRequirement = new HashSet<String>();
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private final Stack<TestStepGroup> groupStack = new Stack();

    public AcceptanceTestRun() {
        this.startTime = System.currentTimeMillis();
    }

    public AcceptanceTestRun(String title) {
        this();
        this.title = title;
        this.methodName = this.normalizedFormOf(title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this);
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    private String normalizedFormOf(String name) {
        return name.replaceAll("\\s", "_").toLowerCase();
    }

    public void testsRequirement(String requirement) {
        Preconditions.checkNotNull((Object)requirement);
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public TestResult getResult() {
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public void recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.groupStack.isEmpty()) {
            this.testSteps.add(step);
        } else {
            this.addStepToCurrentGroup(step);
        }
    }

    private void addStepToCurrentGroup(TestStep step) {
        TestStepGroup group = this.groupStack.peek();
        group.addTestStep(step);
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getSuccessCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSuccessful())).size();
    }

    private List<TestStep> getNestedTestSteps() {
        ArrayList<TestStep> allNestedTestSteps = new ArrayList<TestStep>();
        for (TestStep testStep : this.testSteps) {
            allNestedTestSteps.addAll(testStep.getFlattenedSteps());
        }
        return allNestedTestSteps;
    }

    public Integer getFailureCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isFailure())).size();
    }

    public Integer getIgnoredCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isIgnored())).size();
    }

    public Integer getSkippedCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSkipped())).size();
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getNestedTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Set<String> getAllTestedRequirements() {
        HashSet<String> allTestedRequirements = new HashSet<String>();
        allTestedRequirements.addAll(this.getTestedRequirements());
        for (TestStep step : this.getTestSteps()) {
            allTestedRequirements.addAll(step.getTestedRequirements());
        }
        return allTestedRequirements;
    }

    public void setUserStory(UserStory userStory) {
        this.userStory = userStory;
    }

    public UserStory getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void startGroup(String description) {
        TestStepGroup newGroup = new TestStepGroup(description);
        if (this.currentlyInGroup()) {
            this.addStepToCurrentGroup(newGroup);
        } else {
            this.testSteps.add(newGroup);
        }
        this.groupStack.push(newGroup);
    }

    private boolean currentlyInGroup() {
        return !this.groupStack.isEmpty();
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            TestStepGroup group = this.groupStack.pop();
            group.recordDuration();
        }
    }

    public Integer countTestSteps() {
        return this.getNestedTestSteps().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

