/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.thucydides.core.annotations.At;
import net.thucydides.core.annotations.DefaultUrl;
import net.thucydides.core.annotations.NamedUrl;
import net.thucydides.core.annotations.NamedUrls;
import net.thucydides.core.pages.PageConfiguration;
import net.thucydides.core.pages.RenderedPageObjectView;
import net.thucydides.core.webelements.Checkbox;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageObject {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final int TIMEOUT = 120;
    private long waitForTimeout = 50L;
    private static final String OPTIONAL_PARAMS = "/?(\\?.*)?";
    private static final Map<String, String> MACROS = new HashMap<String, String>();
    private static final long WAIT_FOR_TIMEOUT = 30000L;
    private WebDriver driver;
    private List<Pattern> matchingPageExpressions;
    private RenderedPageObjectView renderedView;
    private String defaultBaseUrl;

    public PageObject(WebDriver driver) {
        MACROS.put("#HOST", "https?://[^/]+");
        this.matchingPageExpressions = new ArrayList<Pattern>();
        AjaxElementLocatorFactory finder = new AjaxElementLocatorFactory(driver, 120);
        this.driver = driver;
        this.waitForTimeout = 30000L;
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)this);
        this.fetchMatchingPageExpressions();
    }

    public void setWaitForTimeout(long waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
    }

    public void setDefaultBaseUrl(String baseUrl) {
        this.defaultBaseUrl = baseUrl;
    }

    public String getDefaultBaseUrl() {
        if (this.defaultBaseUrl == null) {
            return PageConfiguration.getCurrentConfiguration().getBaseUrl();
        }
        return this.defaultBaseUrl;
    }

    private RenderedPageObjectView getRenderedView() {
        if (this.renderedView == null) {
            this.renderedView = new RenderedPageObjectView(this.driver, this.waitForTimeout);
        }
        return this.renderedView;
    }

    private void fetchMatchingPageExpressions() {
        At compatibleWithAnnotation = this.getClass().getAnnotation(At.class);
        if (compatibleWithAnnotation != null) {
            if (this.valueIsDefinedFor(compatibleWithAnnotation)) {
                this.worksWithUrlPattern(compatibleWithAnnotation.value());
            } else {
                this.worksWithUrlPatternList(compatibleWithAnnotation.urls());
            }
        }
    }

    private void worksWithUrlPatternList(String[] urls) {
        for (String url : urls) {
            this.worksWithUrlPattern(url);
        }
    }

    private boolean valueIsDefinedFor(At compatibleWithAnnotation) {
        return compatibleWithAnnotation.value() != null && compatibleWithAnnotation.value().length() > 0;
    }

    private void worksWithUrlPattern(String urlPattern) {
        String processedUrlPattern = this.substituteMacrosIn(urlPattern);
        this.matchingPageExpressions.add(Pattern.compile(processedUrlPattern));
    }

    private String substituteMacrosIn(String urlPattern) {
        String patternWithExpandedMacros = urlPattern;
        for (String macro : MACROS.keySet()) {
            String expanded = MACROS.get(macro);
            patternWithExpandedMacros = patternWithExpandedMacros.replaceAll(macro, expanded);
        }
        patternWithExpandedMacros = patternWithExpandedMacros + OPTIONAL_PARAMS;
        return patternWithExpandedMacros;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        if (this.thereAreNoPatternsDefined()) {
            return true;
        }
        return this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        boolean pageWorksHere = false;
        for (Pattern pattern : this.matchingPageExpressions) {
            if (!this.urlIsCompatibleWithThisPattern(currentUrl, pattern)) continue;
            pageWorksHere = true;
            break;
        }
        return pageWorksHere;
    }

    private boolean thereAreNoPatternsDefined() {
        return this.matchingPageExpressions.isEmpty();
    }

    private boolean urlIsCompatibleWithThisPattern(String currentUrl, Pattern pattern) {
        return pattern.matcher(currentUrl).matches();
    }

    public PageObject waitForRenderedElements(By byElementCriteria) {
        this.getRenderedView().waitFor(byElementCriteria);
        return this;
    }

    public PageObject waitForRenderedElementsToDisappear(By byElementCriteria) {
        this.getRenderedView().waitForElementsToDisappear(byElementCriteria);
        return this;
    }

    public PageObject waitForTextToAppear(String expectedText) {
        this.getRenderedView().waitForText(expectedText);
        return this;
    }

    public PageObject waitForTextToAppear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    public PageObject waitForTextToDisappear(String expectedText) {
        return this.waitForTextToDisappear(expectedText, this.waitForTimeout);
    }

    public PageObject waitForTextToDisappear(String expectedText, long timeout) {
        this.getRenderedView().waitForTextToDisappear(expectedText, timeout);
        return this;
    }

    public PageObject waitForAnyTextToAppear(String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(expectedText);
        return this;
    }

    public PageObject waitForAnyTextToAppear(WebElement element, String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(element, expectedText);
        return this;
    }

    public PageObject waitForAllTextToAppear(String ... expectedTexts) {
        this.getRenderedView().waitForAllTextToAppear(expectedTexts);
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<WebElement> thenReturnElementList(By byListCriteria) {
        return this.driver.findElements(byListCriteria);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the page", textValue);
            throw new NoSuchElementException(errorMessage);
        }
    }

    public void typeInto(WebElement field, String value) {
        field.clear();
        field.sendKeys(new CharSequence[]{value});
    }

    public void selectFromDropdown(WebElement dropdown, String visibleLabel) {
        Select dropdownSelect = this.findSelectFor(dropdown);
        dropdownSelect.selectByVisibleText(visibleLabel);
    }

    public void selectMultipleItemsFromDropdown(WebElement dropdown, String ... selectedLabels) {
        for (String selectedLabel : selectedLabels) {
            String optionPath = String.format("//option[.='%s']", selectedLabel);
            WebElement option = dropdown.findElement(By.xpath((String)optionPath));
            option.click();
        }
    }

    public Set<String> getSelectedOptionLabelsFrom(WebElement dropdown) {
        HashSet<String> selectedOptions = new HashSet<String>();
        List options = dropdown.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            selectedOptions.add(option.getText());
        }
        return selectedOptions;
    }

    public Set<String> getSelectedOptionValuesFrom(WebElement dropdown) {
        HashSet<String> selectedOptions = new HashSet<String>();
        List options = dropdown.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            selectedOptions.add(option.getValue());
        }
        return selectedOptions;
    }

    public void setCheckbox(WebElement field, boolean value) {
        Checkbox checkbox = new Checkbox(field);
        checkbox.setChecked(value);
    }

    protected Select findSelectFor(WebElement dropdownList) {
        return new Select(dropdownList);
    }

    public boolean containsText(String textValue) {
        return this.getRenderedView().containsText(textValue);
    }

    public boolean userCanSee(WebElement field) {
        return this.getRenderedView().userCanSee(field);
    }

    public void shouldBeVisible(WebElement field) {
        if (!this.userCanSee(field)) {
            throw new AssertionError((Object)("The " + field + " element should be visible"));
        }
    }

    public void open() {
        String startingUrl = this.startFromUrlAnnotationOrBaseUrl();
        this.getDriver().get(startingUrl);
    }

    public void open(String ... parameterValues) {
        String startingUrlTemplate = this.startFromUrlAnnotationOrBaseUrl();
        String startingUrl = this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
        this.getDriver().get(startingUrl);
    }

    public static String[] withParameters(String ... parameterValues) {
        return parameterValues;
    }

    public void open(String urlTemplateName, String[] parameterValues) {
        String startingUrlTemplate = this.getNamedUrl(urlTemplateName);
        String startingUrl = this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
        this.getDriver().get(startingUrl);
    }

    public Boolean isElementVisible(By byCriteria) {
        return this.getRenderedView().elementIsDisplayed(byCriteria);
    }

    private String urlWithParametersSubstituted(String template, String[] parameterValues) {
        String url = template;
        for (int i = 0; i < parameterValues.length; ++i) {
            String variable = String.format("{%d}", i + 1);
            url = url.replace(variable, parameterValues[i]);
        }
        return this.addDefaultBaseUrlIfRelative(url);
    }

    private String startFromUrlAnnotationOrBaseUrl() {
        DefaultUrl urlAnnotation = this.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            String annotatedBaseUrl = urlAnnotation.value();
            return this.addDefaultBaseUrlIfRelative(annotatedBaseUrl);
        }
        return this.getDefaultBaseUrl();
    }

    private String addDefaultBaseUrlIfRelative(String url) {
        if (this.isARelativeUrl(url)) {
            return this.getDefaultBaseUrl() + url;
        }
        return url;
    }

    private boolean isARelativeUrl(String url) {
        return url.startsWith("/");
    }

    private String getNamedUrl(String name) {
        NamedUrls urlAnnotation = this.getClass().getAnnotation(NamedUrls.class);
        if (urlAnnotation != null) {
            NamedUrl[] namedUrlList;
            for (NamedUrl namedUrl : namedUrlList = urlAnnotation.value()) {
                if (!namedUrl.name().equals(name)) continue;
                return namedUrl.url();
            }
        }
        throw new IllegalArgumentException("No URL named " + name + " was found in this class");
    }
}

