/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import net.thucydides.core.pages.PageConfiguration;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WrongPageError;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pages {
    private final WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pages.class);
    private String defaultBaseUrl;
    private PageConfiguration pageConfiguration;

    public Pages(WebDriver driver) {
        this.driver = driver;
        this.pageConfiguration = new PageConfiguration();
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void start() {
        Preconditions.checkNotNull((Object)this.driver);
        this.driver.get(this.getDefaultBaseUrl());
    }

    public PageObject currentPageAt(Class<? extends PageObject> pageObjectClass) {
        String currentUrl;
        PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
        if (!pageCandidate.compatibleWithUrl(currentUrl = this.driver.getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        pageCandidate.setDefaultBaseUrl(this.getDefaultBaseUrl());
        return pageCandidate;
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.driver.getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageError e) {
            return false;
        }
    }

    private PageObject getCurrentPageOfType(Class<? extends PageObject> pageObjectClass) {
        PageObject currentPage = null;
        try {
            Class[] constructorArgs = new Class[]{WebDriver.class};
            Constructor<? extends PageObject> constructor = pageObjectClass.getConstructor(constructorArgs);
            currentPage = constructor.newInstance(this.driver);
        }
        catch (Throwable e) {
            LOGGER.info("Failed to instanciate page of type " + pageObjectClass, e);
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
        return currentPage;
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + pageObjectClass + "\n" + "I was at the URL " + this.driver.getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public String getDefaultBaseUrl() {
        if (this.defaultBaseUrl != null) {
            return this.defaultBaseUrl;
        }
        return this.pageConfiguration.getBaseUrl();
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }
}

