/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.ElementNotDisplayedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderedPageObjectView {
    private final WebDriver driver;
    private final long waitForTimeout;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderedPageObjectView.class);

    public RenderedPageObjectView(WebDriver driver, long waitForTimeout) {
        this.driver = driver;
        this.waitForTimeout = waitForTimeout;
    }

    public void waitFor(By byElementCriteria) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.elementIsDisplayed(byElementCriteria)) {
            this.waitABit(50L);
        }
        this.checkThatElementAppeared(byElementCriteria);
        this.checkThatElementIsDisplayed(byElementCriteria);
    }

    private void checkThatElementIsDisplayed(By byElementCriteria) {
        if (!this.elementIsDisplayed(byElementCriteria)) {
            throw new ElementNotDisplayedException("Element not displayed: " + byElementCriteria);
        }
    }

    public boolean elementIsDisplayed(By byElementCriteria) {
        boolean isDisplayed = false;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                return false;
            }
            RenderedWebElement renderedElement = (RenderedWebElement)matchingElements.get(0);
            isDisplayed = renderedElement.isDisplayed();
        }
        catch (NoSuchElementException noSuchElement) {
            LOGGER.trace("No such element " + (Object)((Object)noSuchElement));
        }
        return isDisplayed;
    }

    private void checkThatElementAppeared(By byElementCriteria) {
        this.driver.findElement(byElementCriteria);
    }

    protected void waitABit(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForText(String expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.containsText(expectedText)) {
            this.waitABit(50L);
        }
        if (!this.containsText(expectedText)) {
            throw new ElementNotDisplayedException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    public void waitForText(WebElement element, String expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.containsText(element, expectedText)) {
            this.waitABit(50L);
        }
        if (!this.containsText(element, expectedText)) {
            throw new ElementNotDisplayedException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    public boolean containsText(String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = this.driver.findElements(By.xpath((String)textInBody));
        return !elements.isEmpty();
    }

    public boolean containsText(WebElement element, String textValue) {
        String textInBody = String.format("//body[contains(.,\"%s\")]", textValue);
        List elements = element.findElements(By.xpath((String)textInBody));
        return !elements.isEmpty();
    }

    public boolean userCanSee(WebElement field) {
        if (RenderedWebElement.class.isAssignableFrom(field.getClass())) {
            return ((RenderedWebElement)field).isDisplayed();
        }
        return false;
    }

    public void waitForTextToDisappear(String expectedText, long timeout) {
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end && this.containsText(expectedText)) {
            this.waitABit(50L);
        }
        if (this.containsText(expectedText)) {
            throw new ElementNotDisplayedException("Text was still displayed after timeout: '" + expectedText + "'");
        }
    }

    public void waitForAnyTextToAppear(String ... expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.pageContains(expectedText)) {
            this.waitABit(50L);
        }
        if (!this.pageContains(expectedText)) {
            throw new ElementNotDisplayedException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    public void waitForAnyTextToAppear(WebElement element, String[] expectedText) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && !this.elementContains(element, expectedText)) {
            this.waitABit(50L);
        }
        if (!this.elementContains(element, expectedText)) {
            throw new ElementNotDisplayedException("Expected text was not displayed: '" + expectedText + "'");
        }
    }

    private boolean elementContains(WebElement element, String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(element, expectedText)) continue;
            return true;
        }
        return false;
    }

    private boolean pageContains(String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(expectedText)) continue;
            return true;
        }
        return false;
    }

    public void waitForAllTextToAppear(String ... expectedTexts) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        List<String> requestedTexts = this.buildInitialListOfExpectedTextsFrom(expectedTexts);
        boolean allTextsFound = false;
        while (System.currentTimeMillis() < end) {
            if ((requestedTexts = this.removeAnyTextsPresentOnPageFrom(requestedTexts)).isEmpty()) {
                allTextsFound = true;
                break;
            }
            this.waitABit(50L);
        }
        if (!allTextsFound) {
            throw new ElementNotDisplayedException("Expected text was not displayed: '" + Arrays.toString(requestedTexts.toArray()) + "'");
        }
    }

    private List<String> buildInitialListOfExpectedTextsFrom(String ... expectedTexts) {
        ArrayList<String> requestedTexts = new ArrayList<String>();
        requestedTexts.addAll(Arrays.asList(expectedTexts));
        return requestedTexts;
    }

    private List<String> removeAnyTextsPresentOnPageFrom(List<String> requestedTexts) {
        ArrayList<String> updatedList = new ArrayList<String>();
        updatedList.addAll(requestedTexts);
        for (String requestedText : requestedTexts) {
            if (!this.pageContains(requestedText)) continue;
            updatedList.remove(requestedText);
        }
        return updatedList;
    }

    public void waitForElementsToDisappear(By byElementCriteria) {
        long end = System.currentTimeMillis() + this.waitForTimeout;
        while (System.currentTimeMillis() < end && this.elementIsDisplayed(byElementCriteria)) {
            this.waitABit(50L);
        }
        if (this.elementIsDisplayed(byElementCriteria)) {
            throw new ElementNotDisplayedException("Element should not be displayed displayed: " + byElementCriteria);
        }
    }
}

