/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.UserStoriesResultSet;
import net.thucydides.core.model.UserStoryTestResults;
import net.thucydides.core.model.loaders.UserStoryLoader;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.HtmlReporter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUserStoryTestReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final String DEFAULT_USER_STORY_TEMPLATE = "velocity/user-story.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlUserStoryTestReporter.class);
    private static final String STORIES_TEMPLATE_PATH = "velocity/stories.vm";
    private static final String HOME_TEMPLATE_PATH = "velocity/home.vm";

    public HtmlUserStoryTestReporter() {
        this.setTemplatePath(DEFAULT_USER_STORY_TEMPLATE);
    }

    @Override
    public File generateReportFor(UserStoryTestResults userStoryTestResults) throws IOException {
        LOGGER.info("Generating report for user story " + userStoryTestResults.getTitle() + " to " + this.getOutputDirectory());
        VelocityContext context = new VelocityContext();
        context.put("story", (Object)userStoryTestResults);
        String htmlContents = this.mergeVelocityTemplate(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = userStoryTestResults.getReportName(ReportNamer.ReportType.HTML);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    @Override
    public void generateReportsForStoriesFrom(File sourceDirectory) throws IOException {
        UserStoryLoader loader = new UserStoryLoader();
        List<UserStoryTestResults> userStoryResults = loader.loadStoriesFrom(sourceDirectory);
        this.copyResourcesToOutputDirectory();
        for (UserStoryTestResults userStoryTestResults : userStoryResults) {
            this.generateReportFor(userStoryTestResults);
        }
        this.generateStoriesReportFor(userStoryResults);
    }

    private void generateStoriesReportFor(List<UserStoryTestResults> userStoryResults) throws IOException {
        for (UserStoryTestResults userStory : userStoryResults) {
            System.out.println("Story: " + userStory.getTitle());
        }
        LOGGER.info("Generating summary report for user stories to " + this.getOutputDirectory());
        this.copyResourcesToOutputDirectory();
        this.generateStoriesReport(userStoryResults);
        this.generateReportHomePage(userStoryResults);
    }

    private void generateStoriesReport(List<UserStoryTestResults> userStoryResults) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("stories", userStoryResults);
        Template storyTemplate = this.getTemplateManager().getTemplateFrom(STORIES_TEMPLATE_PATH);
        LOGGER.debug("Generating stories page");
        String htmlContents = this.mergeVelocityTemplate(storyTemplate, context);
        LOGGER.debug("Writing stories page");
        this.writeReportToOutputDirectory("stories.html", htmlContents);
    }

    private void generateReportHomePage(List<UserStoryTestResults> userStoryResults) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("stories", (Object)new UserStoriesResultSet(userStoryResults));
        Template storyTemplate = this.getTemplateManager().getTemplateFrom(HOME_TEMPLATE_PATH);
        LOGGER.debug("Generating home page");
        String htmlContents = this.mergeVelocityTemplate(storyTemplate, context);
        LOGGER.debug("Writing stories page");
        this.writeReportToOutputDirectory("home.html", htmlContents);
    }
}

