/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ConcreteTestStep;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.model.UserStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptanceTestRunConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return AcceptanceTestRun.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        AcceptanceTestRun testRun = (AcceptanceTestRun)value;
        Preconditions.checkNotNull((Object)testRun, (Object)"The test run was null - WTF?");
        writer.addAttribute("title", testRun.getTitle());
        writer.addAttribute("name", testRun.getMethodName());
        writer.addAttribute("steps", Integer.toString(testRun.countTestSteps()));
        writer.addAttribute("successful", Integer.toString(testRun.getSuccessCount()));
        writer.addAttribute("failures", Integer.toString(testRun.getFailureCount()));
        writer.addAttribute("skipped", Integer.toString(testRun.getSkippedCount()));
        writer.addAttribute("ignored", Integer.toString(testRun.getIgnoredCount()));
        writer.addAttribute("pending", Integer.toString(testRun.getPendingCount()));
        writer.addAttribute("result", testRun.getResult().toString());
        this.addUserStoryTo(writer, testRun.getUserStory());
        this.addRequirementsTo(writer, testRun.getTestedRequirements());
        List<TestStep> steps = testRun.getTestSteps();
        for (TestStep step : steps) {
            this.writeStepTo(writer, step);
        }
    }

    private void writeStepTo(HierarchicalStreamWriter writer, TestStep step) {
        if (step instanceof TestStepGroup) {
            writer.startNode("test-group");
            writer.addAttribute("name", step.getDescription());
            List<TestStep> nestedSteps = ((TestStepGroup)step).getSteps();
            for (TestStep nestedStep : nestedSteps) {
                this.writeStepTo(writer, nestedStep);
            }
            writer.endNode();
        } else {
            ConcreteTestStep concreteStep = (ConcreteTestStep)step;
            writer.startNode("test-step");
            this.writeResult(writer, concreteStep);
            this.addRequirementsTo(writer, step.getTestedRequirements());
            this.writeDescription(writer, concreteStep);
            this.writeErrorForFailingTest(writer, concreteStep);
            this.writeScreenshotIfPresent(writer, concreteStep);
            writer.endNode();
        }
    }

    private void addUserStoryTo(HierarchicalStreamWriter writer, UserStory userStory) {
        if (userStory != null) {
            writer.startNode("user-story");
            writer.addAttribute("name", userStory.getName());
            writer.addAttribute("code", userStory.getCode());
            writer.addAttribute("source", userStory.getSource());
            writer.endNode();
        }
    }

    private void addRequirementsTo(HierarchicalStreamWriter writer, Set<String> set) {
        if (!set.isEmpty()) {
            writer.startNode("requirements");
            for (String requirement : set) {
                writer.startNode("requirement");
                writer.setValue(requirement);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeErrorForFailingTest(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.isFailure().booleanValue()) {
            this.writeErrorMessageAndException(writer, step);
        }
    }

    private void writeErrorMessageAndException(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.getErrorMessage() != null) {
            this.writeErrorMessageNode(writer, step.getErrorMessage());
            if (step.getException() != null) {
                this.writeExceptionNode(writer, step.getException());
            }
        }
    }

    private void writeExceptionNode(HierarchicalStreamWriter writer, Throwable cause) {
        writer.startNode("exception");
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stringWriter));
        writer.setValue(stringWriter.toString());
        writer.endNode();
    }

    private void writeErrorMessageNode(HierarchicalStreamWriter writer, String errorMessage) {
        writer.startNode("error");
        writer.setValue(errorMessage);
        writer.endNode();
    }

    private void writeScreenshotIfPresent(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.getScreenshot() != null) {
            writer.startNode("screenshot");
            writer.setValue(step.getScreenshot().getName());
            writer.endNode();
        }
    }

    private void writeResult(HierarchicalStreamWriter writer, TestStep step) {
        writer.addAttribute("result", step.getResult().toString());
    }

    private void writeDescription(HierarchicalStreamWriter writer, TestStep step) {
        writer.startNode("description");
        writer.setValue(step.getDescription());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        AcceptanceTestRun testRun = new AcceptanceTestRun();
        testRun.setTitle(reader.getAttribute("title"));
        testRun.setMethodName(reader.getAttribute("name"));
        this.readChildren(reader, testRun);
        return testRun;
    }

    private void readChildren(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals("test-step")) {
                this.readTestStep(reader, testRun);
            } else if (childNode.equals("test-group")) {
                this.readTestGroup(reader, testRun);
            } else if (childNode.equals("requirements")) {
                this.readTestRunRequirements(reader, testRun);
            } else if (childNode.equals("user-story")) {
                this.readUserStory(reader, testRun);
            }
            reader.moveUp();
        }
    }

    private void readUserStory(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        String storyName = reader.getAttribute("name");
        String storyCode = reader.getAttribute("code");
        String storySource = reader.getAttribute("source");
        testRun.setUserStory(new UserStory(storyName, storyCode, storySource));
    }

    private void readTestRunRequirements(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            testRun.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStepRequirements(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            step.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStep(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        ConcreteTestStep step = new ConcreteTestStep();
        String testResultValue = reader.getAttribute("result");
        TestResult result = TestResult.valueOf(testResultValue);
        step.setResult(result);
        this.readTestStepChildren(reader, step);
        testRun.recordStep(step);
    }

    private void readTestGroup(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        String name = reader.getAttribute("name");
        testRun.startGroup(name);
        this.readChildren(reader, testRun);
        testRun.endGroup();
    }

    private void readTestStepChildren(HierarchicalStreamReader reader, ConcreteTestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals("description")) {
                step.setDescription(reader.getValue());
            } else if (childNode.equals("requirements")) {
                this.readTestStepRequirements(reader, step);
            } else if (childNode.equals("screenshot")) {
                step.setScreenshotPath(reader.getValue());
            }
            reader.moveUp();
        }
    }
}

