/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.HtmlAcceptanceTestReporter;
import net.thucydides.core.reports.xml.XMLAcceptanceTestReporter;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String WEBDRIVER_DRIVER = "webdriver.driver";
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final String OUTPUT_DIRECTORY_PROPERTY = "thucydides.outputDirectory";
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/thucydides";
    private File outputDirectory;

    public SupportedWebDriver getDriverType() {
        String driverType = System.getProperty(WEBDRIVER_DRIVER, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = System.getProperty(OUTPUT_DIRECTORY_PROPERTY);
        if (systemDefinedDirectory == null) {
            systemDefinedDirectory = DEFAULT_OUTPUT_DIRECTORY;
        }
        return new File(systemDefinedDirectory);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
            this.outputDirectory.mkdirs();
        }
        return this.outputDirectory;
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.valueOf(driverType.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }

    public Collection<? extends AcceptanceTestReporter> getDefaultReporters() {
        return ImmutableList.of((Object)new XMLAcceptanceTestReporter(), (Object)new HtmlAcceptanceTestReporter());
    }
}

