/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.WebDriver;

public class WebdriverManager {
    private WebDriverFactory webDriverFactory;
    private Configuration configuration;
    private ThreadLocal<WebDriver> webdriver = new ThreadLocal();

    public WebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
        this.initializeDriver();
    }

    private void initializeDriver() {
        this.webdriver.set(this.newDriver());
    }

    protected WebDriver newDriver() {
        SupportedWebDriver supportedDriverType = this.configuration.getDriverType();
        return this.webDriverFactory.newInstanceOf(supportedDriverType);
    }

    public void closeDriver() {
        if (this.webdriver != null && this.webdriver.get() != null) {
            this.webdriver.get().quit();
            this.webdriver.remove();
        }
    }

    public WebDriver getWebdriver() {
        return this.webdriver.get();
    }
}

