/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestStep {
    private String description;
    private long duration;
    private long startTime;
    private Set<String> testedRequirement = new HashSet<String>();

    public TestStep() {
        this.startTime = System.currentTimeMillis();
    }

    public TestStep(String description) {
        this();
        this.description = description;
    }

    public void testsRequirement(String requirement) {
        this.testedRequirement.add(requirement);
    }

    public Set<String> getTestedRequirements() {
        return ImmutableSet.copyOf(this.testedRequirement);
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract TestResult getResult();

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public abstract List<? extends TestStep> getFlattenedSteps();

    public abstract boolean isAGroup();
}

