/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.loaders;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.UserStory;
import net.thucydides.core.model.UserStoryTestResults;
import net.thucydides.core.reports.xml.NotAThucydidesReportException;
import net.thucydides.core.reports.xml.XMLAcceptanceTestReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStoryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStoryLoader.class);

    public List<UserStoryTestResults> loadStoriesFrom(File reportDirectory) throws IOException {
        File[] reportFiles;
        ArrayList<UserStoryTestResults> userStories = new ArrayList<UserStoryTestResults>();
        XMLAcceptanceTestReporter acceptanceTestReporter = new XMLAcceptanceTestReporter();
        for (File reportFile : reportFiles = this.getAllXMLFilesFrom(reportDirectory)) {
            try {
                AcceptanceTestRun testRun = acceptanceTestReporter.loadReportFrom(reportFile);
                UserStoryTestResults userStoryResults = this.userStoryResultsFor(testRun, userStories);
                userStoryResults.recordTestRun(testRun);
            }
            catch (NotAThucydidesReportException e) {
                LOGGER.info("Skipping XML file - not a Thucydides report: " + reportFile);
            }
        }
        return userStories;
    }

    private UserStoryTestResults userStoryResultsFor(AcceptanceTestRun testRun, List<UserStoryTestResults> userStoryResults) {
        UserStory userStory = testRun.getUserStory();
        for (UserStoryTestResults userStoryResult : userStoryResults) {
            if (!userStoryResult.containsResultsFor(userStory)) continue;
            return userStoryResult;
        }
        UserStoryTestResults userStoryTestResults = new UserStoryTestResults(userStory);
        userStoryResults.add(userStoryTestResults);
        return userStoryTestResults;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new XmlFilenameFilter());
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

