/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.thucydides.core.annotations.At;
import net.thucydides.core.pages.PageObject;

public class MatchingPageExpressions {
    private final List<Pattern> matchingExpressions = new ArrayList<Pattern>();
    private static final Map<String, String> MACROS = new HashMap<String, String>();
    private static final String OPTIONAL_PARAMS = "/?(\\?.*)?";

    public MatchingPageExpressions(PageObject pageObject) {
        this.buildMatchingExpressionsList(pageObject);
    }

    private void buildMatchingExpressionsList(PageObject pageObject) {
        At compatibleWithAnnotation = pageObject.getClass().getAnnotation(At.class);
        if (compatibleWithAnnotation != null) {
            if (this.valueIsDefinedFor(compatibleWithAnnotation)) {
                this.worksWithUrlPattern(compatibleWithAnnotation.value());
            } else {
                this.worksWithUrlPatternList(compatibleWithAnnotation.urls());
            }
        }
    }

    public boolean isEmpty() {
        return this.matchingExpressions.isEmpty();
    }

    public boolean matchUrlAgainstEachPattern(String currentUrl) {
        boolean pageWorksHere = false;
        for (Pattern pattern : this.matchingExpressions) {
            if (!this.urlIsCompatibleWithThisPattern(currentUrl, pattern)) continue;
            pageWorksHere = true;
            break;
        }
        return pageWorksHere;
    }

    private boolean urlIsCompatibleWithThisPattern(String currentUrl, Pattern pattern) {
        return pattern.matcher(currentUrl).matches();
    }

    private void worksWithUrlPatternList(String[] urls) {
        for (String url : urls) {
            this.worksWithUrlPattern(url);
        }
    }

    private boolean valueIsDefinedFor(At compatibleWithAnnotation) {
        return compatibleWithAnnotation.value() != null && compatibleWithAnnotation.value().length() > 0;
    }

    private void worksWithUrlPattern(String urlPattern) {
        String processedUrlPattern = this.substituteMacrosIn(urlPattern);
        this.matchingExpressions.add(Pattern.compile(processedUrlPattern));
    }

    private String substituteMacrosIn(String urlPattern) {
        String patternWithExpandedMacros = urlPattern;
        for (String macro : MACROS.keySet()) {
            String expanded = MACROS.get(macro);
            patternWithExpandedMacros = patternWithExpandedMacros.replaceAll(macro, expanded);
        }
        patternWithExpandedMacros = patternWithExpandedMacros + OPTIONAL_PARAMS;
        return patternWithExpandedMacros;
    }

    static {
        MACROS.put("#HOST", "https?://[^/]+");
    }
}

