/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import net.thucydides.core.annotations.DefaultUrl;
import net.thucydides.core.annotations.NamedUrl;
import net.thucydides.core.annotations.NamedUrls;
import net.thucydides.core.pages.PageConfiguration;

class PageUrls {
    private Object pageObject;
    private String pageLevelDefaultBaseUrl;

    public PageUrls(Object pageObject) {
        this.pageObject = pageObject;
    }

    public String getStartingUrl() {
        DefaultUrl urlAnnotation = this.pageObject.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            String annotatedBaseUrl = urlAnnotation.value();
            return this.addDefaultBaseUrlIfRelative(annotatedBaseUrl);
        }
        return this.getDefaultUrl();
    }

    private String getDefaultUrl() {
        if (this.pageLevelDefaultBaseUrl != null) {
            return this.pageLevelDefaultBaseUrl;
        }
        return PageConfiguration.getCurrentConfiguration().getBaseUrl();
    }

    public String getStartingUrl(String ... parameterValues) {
        String startingUrlTemplate = this.getStartingUrl();
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    public String getNamedUrl(String name) {
        NamedUrls urlAnnotation = this.pageObject.getClass().getAnnotation(NamedUrls.class);
        if (urlAnnotation != null) {
            NamedUrl[] namedUrlList;
            for (NamedUrl namedUrl : namedUrlList = urlAnnotation.value()) {
                if (!namedUrl.name().equals(name)) continue;
                return namedUrl.url();
            }
        }
        throw new IllegalArgumentException("No URL named " + name + " was found in this class");
    }

    public String getNamedUrl(String name, String[] parameterValues) {
        String startingUrlTemplate = this.getNamedUrl(name);
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    private String urlWithParametersSubstituted(String template, String[] parameterValues) {
        String url = template;
        for (int i = 0; i < parameterValues.length; ++i) {
            String variable = String.format("{%d}", i + 1);
            url = url.replace(variable, parameterValues[i]);
        }
        return this.addDefaultBaseUrlIfRelative(url);
    }

    private String addDefaultBaseUrlIfRelative(String url) {
        if (this.isARelativeUrl(url)) {
            return this.getDefaultUrl() + url;
        }
        return url;
    }

    private boolean isARelativeUrl(String url) {
        return url.startsWith("/");
    }

    public void overrideDefaultBaseUrl(String defaultBaseUrl) {
        this.pageLevelDefaultBaseUrl = defaultBaseUrl;
    }
}

