/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.reports.AcceptanceTestReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportService {
    private File outputDirectory;
    private List<AcceptanceTestReporter> subscribedReporters;

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters) {
        this.outputDirectory = outputDirectory;
        this.getSubscribedReporters().addAll(subscribedReporters);
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        if (this.subscribedReporters == null) {
            this.subscribedReporters = new ArrayList<AcceptanceTestReporter>();
        }
        return this.subscribedReporters;
    }

    public void subscribe(AcceptanceTestReporter reporter) {
        this.getSubscribedReporters().add(reporter);
    }

    public void generateReportsFor(List<AcceptanceTestRun> testRunResults) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            for (AcceptanceTestRun testRunResult : testRunResults) {
                this.generateReportFor(testRunResult, reporter);
            }
        }
    }

    private void generateReportFor(AcceptanceTestRun acceptanceTestRun, AcceptanceTestReporter reporter) {
        try {
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportFor(acceptanceTestRun);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to generate reports using " + reporter, e);
        }
    }
}

