/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ConcreteTestStep;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestStepGroup;
import net.thucydides.core.model.UserStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptanceTestRunConverter
implements Converter {
    private static final String TITLE_FIELD = "title";
    private static final String NAME_FIELD = "name";
    private static final String STEPS_FIELD = "steps";
    private static final String SUCCESSFUL_FIELD = "successful";
    private static final String FAILURES_FIELD = "failures";
    private static final String SKIPPED_FIELD = "skipped";
    private static final String IGNORED_FIELD = "ignored";
    private static final String PENDING_FIELD = "pending";
    private static final String RESULT_FIELD = "result";
    private static final String TEST_GROUP = "test-group";
    private static final String TEST_STEP = "test-step";
    private static final String USER_STORY = "user-story";
    private static final String CODE_FIELD = "code";
    private static final String SOURCE_FIELD = "source";
    private static final String REQUIREMENTS = "requirements";
    private static final String REQUIREMENT = "requirement";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    private static final String SCREENSHOT = "screenshot";
    private static final String DESCRIPTION = "description";

    public boolean canConvert(Class clazz) {
        return AcceptanceTestRun.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        AcceptanceTestRun testRun = (AcceptanceTestRun)value;
        Preconditions.checkNotNull((Object)testRun, (Object)"The test run was null - WTF?");
        writer.addAttribute(TITLE_FIELD, testRun.getTitle());
        writer.addAttribute(NAME_FIELD, testRun.getMethodName());
        writer.addAttribute(STEPS_FIELD, Integer.toString(testRun.countTestSteps()));
        writer.addAttribute(SUCCESSFUL_FIELD, Integer.toString(testRun.getSuccessCount()));
        writer.addAttribute(FAILURES_FIELD, Integer.toString(testRun.getFailureCount()));
        writer.addAttribute(SKIPPED_FIELD, Integer.toString(testRun.getSkippedCount()));
        writer.addAttribute(IGNORED_FIELD, Integer.toString(testRun.getIgnoredCount()));
        writer.addAttribute(PENDING_FIELD, Integer.toString(testRun.getPendingCount()));
        writer.addAttribute(RESULT_FIELD, testRun.getResult().toString());
        this.addUserStoryTo(writer, testRun.getUserStory());
        this.addRequirementsTo(writer, testRun.getTestedRequirements());
        List<TestStep> steps = testRun.getTestSteps();
        for (TestStep step : steps) {
            this.writeStepTo(writer, step);
        }
    }

    private void writeStepTo(HierarchicalStreamWriter writer, TestStep step) {
        if (step instanceof TestStepGroup) {
            writer.startNode(TEST_GROUP);
            writer.addAttribute(NAME_FIELD, step.getDescription());
            List<TestStep> nestedSteps = ((TestStepGroup)step).getSteps();
            for (TestStep nestedStep : nestedSteps) {
                this.writeStepTo(writer, nestedStep);
            }
            writer.endNode();
        } else {
            ConcreteTestStep concreteStep = (ConcreteTestStep)step;
            writer.startNode(TEST_STEP);
            this.writeResult(writer, concreteStep);
            this.addRequirementsTo(writer, step.getTestedRequirements());
            this.writeDescription(writer, concreteStep);
            this.writeErrorForFailingTest(writer, concreteStep);
            this.writeScreenshotIfPresent(writer, concreteStep);
            writer.endNode();
        }
    }

    private void addUserStoryTo(HierarchicalStreamWriter writer, UserStory userStory) {
        if (userStory != null) {
            writer.startNode(USER_STORY);
            writer.addAttribute(NAME_FIELD, userStory.getName());
            writer.addAttribute(CODE_FIELD, userStory.getCode());
            writer.addAttribute(SOURCE_FIELD, userStory.getSource());
            writer.endNode();
        }
    }

    private void addRequirementsTo(HierarchicalStreamWriter writer, Set<String> set) {
        if (!set.isEmpty()) {
            writer.startNode(REQUIREMENTS);
            for (String requirement : set) {
                writer.startNode(REQUIREMENT);
                writer.setValue(requirement);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeErrorForFailingTest(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.isFailure().booleanValue()) {
            this.writeErrorMessageAndException(writer, step);
        }
    }

    private void writeErrorMessageAndException(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.getErrorMessage() != null) {
            this.writeErrorMessageNode(writer, step.getErrorMessage());
            if (step.getException() != null) {
                this.writeExceptionNode(writer, step.getException());
            }
        }
    }

    private void writeExceptionNode(HierarchicalStreamWriter writer, Throwable cause) {
        writer.startNode(EXCEPTION);
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter(stringWriter));
        writer.setValue(stringWriter.toString());
        writer.endNode();
    }

    private void writeErrorMessageNode(HierarchicalStreamWriter writer, String errorMessage) {
        writer.startNode(ERROR);
        writer.setValue(errorMessage);
        writer.endNode();
    }

    private void writeScreenshotIfPresent(HierarchicalStreamWriter writer, ConcreteTestStep step) {
        if (step.getScreenshot() != null) {
            writer.startNode(SCREENSHOT);
            writer.setValue(step.getScreenshot().getName());
            writer.endNode();
        }
    }

    private void writeResult(HierarchicalStreamWriter writer, TestStep step) {
        writer.addAttribute(RESULT_FIELD, step.getResult().toString());
    }

    private void writeDescription(HierarchicalStreamWriter writer, TestStep step) {
        writer.startNode(DESCRIPTION);
        writer.setValue(step.getDescription());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        AcceptanceTestRun testRun = new AcceptanceTestRun();
        testRun.setTitle(reader.getAttribute(TITLE_FIELD));
        testRun.setMethodName(reader.getAttribute(NAME_FIELD));
        this.readChildren(reader, testRun);
        return testRun;
    }

    private void readChildren(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(TEST_STEP)) {
                this.readTestStep(reader, testRun);
            } else if (childNode.equals(TEST_GROUP)) {
                this.readTestGroup(reader, testRun);
            } else if (childNode.equals(REQUIREMENTS)) {
                this.readTestRunRequirements(reader, testRun);
            } else if (childNode.equals(USER_STORY)) {
                this.readUserStory(reader, testRun);
            }
            reader.moveUp();
        }
    }

    private void readUserStory(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        String storyName = reader.getAttribute(NAME_FIELD);
        String storyCode = reader.getAttribute(CODE_FIELD);
        String storySource = reader.getAttribute(SOURCE_FIELD);
        testRun.setUserStory(new UserStory(storyName, storyCode, storySource));
    }

    private void readTestRunRequirements(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            testRun.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStepRequirements(HierarchicalStreamReader reader, TestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String requirement = reader.getValue();
            step.testsRequirement(requirement);
            reader.moveUp();
        }
    }

    private void readTestStep(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        ConcreteTestStep step = new ConcreteTestStep();
        String testResultValue = reader.getAttribute(RESULT_FIELD);
        TestResult result = TestResult.valueOf(testResultValue);
        step.setResult(result);
        this.readTestStepChildren(reader, step);
        testRun.recordStep(step);
    }

    private void readTestGroup(HierarchicalStreamReader reader, AcceptanceTestRun testRun) {
        String name = reader.getAttribute(NAME_FIELD);
        testRun.startGroup(name);
        this.readChildren(reader, testRun);
        testRun.endGroup();
    }

    private void readTestStepChildren(HierarchicalStreamReader reader, ConcreteTestStep step) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String childNode = reader.getNodeName();
            if (childNode.equals(DESCRIPTION)) {
                step.setDescription(reader.getValue());
            } else if (childNode.equals(REQUIREMENTS)) {
                this.readTestStepRequirements(reader, step);
            } else if (childNode.equals(SCREENSHOT)) {
                step.setScreenshotPath(reader.getValue());
            }
            reader.moveUp();
        }
    }
}

