/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thucydides.core.model.AcceptanceTestRun;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.xml.AcceptanceTestRunConverter;
import net.thucydides.core.reports.xml.NotAThucydidesReportException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLAcceptanceTestReporter
implements AcceptanceTestReporter {
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLAcceptanceTestReporter.class);

    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    public File generateReportFor(AcceptanceTestRun testRun) throws IOException {
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", AcceptanceTestRun.class);
        xstream.registerConverter((Converter)new AcceptanceTestRunConverter());
        String xmlContents = xstream.toXML((Object)testRun);
        String reportFilename = testRun.getReportName(ReportNamer.ReportType.XML);
        File report = new File(this.getOutputDirectory(), reportFilename);
        LOGGER.debug("Writing XML report to " + report.getAbsolutePath());
        FileUtils.writeStringToFile((File)report, (String)xmlContents);
        return report;
    }

    public AcceptanceTestRun loadReportFrom(File reportFile) throws NotAThucydidesReportException, IOException {
        InputStream input = null;
        try {
            XStream xstream = new XStream();
            xstream.alias("acceptance-test-run", AcceptanceTestRun.class);
            xstream.registerConverter((Converter)new AcceptanceTestRunConverter());
            input = new FileInputStream(reportFile);
            AcceptanceTestRun acceptanceTestRun = (AcceptanceTestRun)xstream.fromXML(input);
            return acceptanceTestRun;
        }
        catch (CannotResolveClassException e) {
            throw new NotAThucydidesReportException("This file is not a thucydides report: " + reportFile, e);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

