/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.thucydides.core.resources.ResourceCopyingError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceList {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    private ResourceList() {
    }

    public static Collection<String> getResources(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> resources = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(PATH_SEPARATOR)) {
            resources.addAll(ResourceList.getResources(element, pattern));
        }
        return resources;
    }

    private static Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File file = new File(element);
        if (ResourceList.isAJarFile(file)) {
            resources.addAll(ResourceList.getResourcesFromJarFile(file, pattern));
        } else {
            resources.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
        }
        return resources;
    }

    private static boolean isAJarFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        if (file.exists()) {
            ZipFile zf;
            try {
                zf = new ZipFile(file);
            }
            catch (ZipException e) {
                throw new ResourceCopyingError("Could not open the JAR file", e);
            }
            catch (IOException e) {
                throw new ResourceCopyingError("Could not read from the JAR file", e);
            }
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String fileName = ze.getName();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName);
            }
            try {
                zf.close();
            }
            catch (IOException e1) {
                throw new ResourceCopyingError("Couldn't close the zip file", e1);
            }
        }
        return retval;
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory() && file.exists()) {
                    retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
                    continue;
                }
                if (!file.exists()) continue;
                try {
                    String fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (!accept) continue;
                    retval.add(fileName);
                }
                catch (IOException e) {
                    throw new ResourceCopyingError("Could not read from the JAR file", e);
                }
            }
        }
        return retval;
    }
}

